/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractOpenDeclarationHandler;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.sourceediting.ROpenDeclaration;
import org.eclipse.ui.PartInitException;

public class ROpenDeclarationHandler
extends AbstractOpenDeclarationHandler {
    public static RElementAccess searchAccess(ISourceEditor editor, IRegion region) {
        RHeuristicTokenScanner scanner;
        IDocument document;
        block6: {
            document = editor.getViewer().getDocument();
            scanner = RHeuristicTokenScanner.create((IDocContentSections)editor.getDocumentContentInfo());
            if (scanner != null) break block6;
            return null;
        }
        try {
            RAstNode node;
            AstInfo astInfo;
            AstSelection astSelection;
            AstNode covering;
            IRModelInfo modelInfo;
            ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)scanner.getDocumentPartitioning(), (int)region.getOffset(), (boolean)false);
            ISourceUnit su = editor.getSourceUnit();
            if (su instanceof IRSourceUnit && region.getOffset() < document.getLength() && (IRDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partition.getType()) && !RTokens.isRobustSeparator((int)document.getChar(region.getOffset()), (boolean)false) || partition.getType() == "R.QuotedSymbol" || partition.getType() == "R.String") && (modelInfo = (IRModelInfo)su.getModelInfo("R", 2, (IProgressMonitor)new NullProgressMonitor())) != null && (covering = (astSelection = AstSelection.search((AstNode)(astInfo = modelInfo.getAst()).getRoot(), (int)region.getOffset(), (int)(region.getOffset() + region.getLength()), (int)3)).getCovering()) instanceof RAstNode && ((node = (RAstNode)covering).getNodeType() == NodeType.SYMBOL || node.getNodeType() == NodeType.STRING_CONST)) {
                RAstNode current = node;
                do {
                    ImList attachments = current.getAttachments();
                    for (Object attachment : attachments) {
                        RElementAccess access;
                        if (!(attachment instanceof RElementAccess) || (access = (RElementAccess)attachment).getNameNode() != node) continue;
                        return access;
                    }
                } while ((current = current.getRParent()) != null);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    public boolean execute(ISourceEditor editor, IRegion selection) {
        RElementAccess access = ROpenDeclarationHandler.searchAccess(editor, selection);
        if (access != null) {
            try {
                List list = RModel.searchDeclaration((RElementAccess)access, (IRSourceUnit)((IRSourceUnit)editor.getSourceUnit()));
                ROpenDeclaration open = new ROpenDeclaration();
                ISourceElement element = (ISourceElement)open.selectElement(list, editor.getWorkbenchPart());
                if (element != null) {
                    open.open(element, true);
                    return true;
                }
            }
            catch (PartInitException e) {
                this.logError((Exception)((Object)e), access.getDisplayName());
            }
            catch (CoreException e) {
                return true;
            }
        }
        return false;
    }
}

