/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.statet.internal.r.core.sourcemodel.BuildSourceFrame;
import org.eclipse.statet.internal.r.core.sourcemodel.IBuildSourceFrameElement;
import org.eclipse.statet.internal.r.core.sourcemodel.RSourceElements;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangSourceElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

final class RoxygenRCodeElement
implements IBuildSourceFrameElement {
    private final IRLangSourceElement parent;
    private final int number;
    private final RAstNode sourceNode;
    private final List<? extends IRLangSourceElement> sourceChildrenProtected = RSourceElements.NO_R_SOURCE_CHILDREN;
    private BuildSourceFrame envir;

    public RoxygenRCodeElement(IRLangSourceElement parent, int number, BuildSourceFrame envir, RAstNode node) {
        this.parent = parent;
        this.number = number;
        this.sourceNode = node;
    }

    @Override
    public void setSourceChildren(List<? extends IRLangSourceElement> children) {
    }

    @Override
    public BuildSourceFrame getBuildFrame() {
        return this.envir;
    }

    public String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 644;
    }

    @Override
    public RElementName getElementName() {
        return null;
    }

    public String getId() {
        return String.valueOf(Integer.toHexString(644)) + ":#" + this.number;
    }

    public boolean exists() {
        return this.getSourceUnit().exists();
    }

    public boolean isReadOnly() {
        return this.getSourceUnit().isReadOnly();
    }

    @Override
    public IRElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IRLangSourceElement> getModelChildren(IModelElement.Filter filter) {
        return RSourceElements.NO_R_SOURCE_CHILDREN;
    }

    public ISourceStructElement getSourceParent() {
        return this.parent;
    }

    @Override
    public boolean hasSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.hasChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public List<? extends IRLangSourceElement> getSourceChildren(IModelElement.Filter filter) {
        return RSourceElements.getChildren(this.sourceChildrenProtected, filter);
    }

    @Override
    public IRSourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public TextRegion getSourceRange() {
        return this.sourceNode;
    }

    public TextRegion getNameSourceRange() {
        return null;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == AstNode.class) {
            return (T)((Object)this.sourceNode);
        }
        if (adapterType == IRFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public int hashCode() {
        return this.parent.hashCode() + this.number;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RoxygenRCodeElement)) {
            return false;
        }
        RoxygenRCodeElement other = (RoxygenRCodeElement)obj;
        return (other.getElementType() & 0xFFF) == 644 && this.number == other.number && this.parent.equals(other.parent);
    }
}

