/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.docmlet.wikitext.core.source.WikitextHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.IDocContentSections;
import org.eclipse.statet.ecommons.text.ui.BracketLevel;

public class WikitextBracketLevel
extends BracketLevel {
    public static BracketLevel.InBracketPosition createPosition(char c, IDocument document, int offset, int length, int sequence) {
        switch (c) {
            case '{': {
                return new CurlyBracketPosition(document, offset, length, sequence);
            }
            case '[': {
                return new SquareBracketPosition(document, offset, length, sequence);
            }
            case '(': {
                return new ParanthesisBracket(document, offset, length, sequence);
            }
            case '$': {
                return new MathDollarBracket(document, offset, length, sequence);
            }
        }
        throw new IllegalArgumentException("Invalid position type: " + c);
    }

    public WikitextBracketLevel(LinkedModeModel model, IDocument document, IDocContentSections docContentSections, List<LinkedPosition> positions, int mode) {
        super(model, document, docContentSections, positions, mode);
    }

    public static final class CurlyBracketPosition
    extends BracketLevel.InBracketPosition {
        public CurlyBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)offset);
        }
    }

    public static final class MathDollarBracket
    extends BracketLevel.InBracketPosition {
        public MathDollarBracket(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '$';
        }

        public char getCloseChar() {
            return '$';
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)offset);
        }
    }

    public static final class ParanthesisBracket
    extends BracketLevel.InBracketPosition {
        public ParanthesisBracket(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '(';
        }

        public char getCloseChar() {
            return ')';
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)offset);
        }
    }

    public static final class SquareBracketPosition
    extends BracketLevel.InBracketPosition {
        public SquareBracketPosition(IDocument document, int offset, int length, int sequence) {
            super(document, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return WikitextHeuristicTokenScanner.isEscaped((IDocument)this.getDocument(), (int)offset);
        }
    }
}

