/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.resources.core.BuildUtils;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ManagedConfigurationBlock
extends ConfigurationBlock
implements PreferenceAccess,
IObservableFactory {
    private static final String REBUILD_QUALIFIER = "org.eclipse.jdt.ui";
    private static final String REBUILD_KEY = "preferences_build_requested";
    private final IProject project;
    private PreferenceManager preferenceManager;
    private DataBindingSupport dataBinding;
    private StatusChangeListener statusListener;
    private Composite pageComposite;

    protected ManagedConfigurationBlock(IProject project) {
        this(project, null, null);
    }

    protected ManagedConfigurationBlock(IProject project, StatusChangeListener statusListener) {
        this(project, null, statusListener);
    }

    protected ManagedConfigurationBlock(IProject project, String title, StatusChangeListener statusListener) {
        super(title);
        this.project = project;
        this.statusListener = statusListener;
    }

    protected void setStatusListener(StatusChangeListener listener) {
        this.statusListener = listener;
    }

    public final IProject getProject() {
        return this.project;
    }

    @Override
    public void createContents(Composite pageComposite, IWorkbenchPreferenceContainer container, IPreferenceStore preferenceStore) {
        this.pageComposite = pageComposite;
        super.createContents(pageComposite, container, preferenceStore);
    }

    protected void setupPreferenceManager(Map<Preference<?>, String> prefs) {
        new PreferenceManager(prefs);
    }

    protected void initBindings() {
        this.dataBinding = new DataBindingSupport((Control)this.pageComposite);
        this.addBindings(this.dataBinding);
        this.dataBinding.installStatusListener(this.statusListener);
    }

    protected DataBindingSupport getDataBinding() {
        return this.dataBinding;
    }

    protected void addBindings(DataBindingSupport db) {
    }

    protected void updatePreferences() {
    }

    @Override
    public boolean performOk(int flags) {
        if (this.preferenceManager != null) {
            this.updatePreferences();
            return this.preferenceManager.processChanges((flags & 0x10) != 0);
        }
        return true;
    }

    @Override
    public void performDefaults() {
        if (this.preferenceManager != null) {
            this.preferenceManager.loadDefaults();
            this.updateControls();
        }
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null && this.preferenceManager != null) {
            return this.preferenceManager.hasProjectSpecificSettings(project);
        }
        return false;
    }

    @Override
    public void setUseProjectSpecificSettings(boolean enable) {
        super.setUseProjectSpecificSettings(enable);
        if (this.project != null && this.preferenceManager != null) {
            this.preferenceManager.setUseProjectSpecificSettings(enable);
        }
    }

    protected void updateControls() {
        if (this.dataBinding != null) {
            this.dataBinding.getContext().updateTargets();
        }
    }

    public ImList<IScopeContext> getPreferenceContexts() {
        assert (this.preferenceManager != null);
        return this.preferenceManager.lookupOrder;
    }

    public <T> T getPreferenceValue(Preference<T> pref) {
        assert (this.preferenceManager != null);
        assert (pref != null);
        if (this.preferenceManager.disabledProjectSettings != null) {
            return (T)this.preferenceManager.disabledProjectSettings.get(pref);
        }
        return (T)this.preferenceManager.getValue(pref);
    }

    public <T> T setPrefValue(Preference<T> key, T value) {
        assert (this.preferenceManager != null);
        if (this.preferenceManager.disabledProjectSettings != null) {
            return this.preferenceManager.disabledProjectSettings.put(key, value);
        }
        T oldValue = this.getPreferenceValue(key);
        this.preferenceManager.setValue(key, value);
        return oldValue;
    }

    public void setPrefValues(Map<Preference<?>, Object> map) {
        for (Map.Entry<Preference<?>, Object> entry : map.entrySet()) {
            this.setPrefValue(entry.getKey(), entry.getValue());
        }
    }

    public void addPreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removePreferenceNodeListener(String nodeQualifier, IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addPreferenceSetListener(PreferenceSetService.ChangeListener listener, ImSet<String> qualifiers) {
        throw new UnsupportedOperationException();
    }

    public void removePreferenceSetListener(PreferenceSetService.ChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public IObservableValue createObservable(Object target) {
        return this.createObservable((Preference)target);
    }

    public <T> IObservableValue<T> createObservable(final Preference<T> pref) {
        return new AbstractObservableValue<T>(){

            public Object getValueType() {
                return pref.getUsageType();
            }

            protected void doSetValue(T value) {
                ManagedConfigurationBlock.this.setPrefValue(pref, value);
            }

            protected T doGetValue() {
                return ManagedConfigurationBlock.this.getPreferenceValue(pref);
            }

            public synchronized void dispose() {
                super.dispose();
            }
        };
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    protected class PreferenceManager {
        private final ImList<IScopeContext> lookupOrder;
        private final IScopeContext inheritScope;
        private final Map<Preference<?>, String> preferences;
        private final IWorkingCopyManager manager;
        private Map<Preference<?>, Object> disabledProjectSettings;
        private int rebuildCounter;

        PreferenceManager(Map<Preference<?>, String> prefs) {
            this.manager = ManagedConfigurationBlock.this.getContainer().getWorkingCopyManager();
            this.preferences = prefs;
            ManagedConfigurationBlock.this.preferenceManager = this;
            if (ManagedConfigurationBlock.this.project != null) {
                this.lookupOrder = ImCollections.newList((Object[])new IScopeContext[]{new ProjectScope(ManagedConfigurationBlock.this.project), InstanceScope.INSTANCE, DefaultScope.INSTANCE});
                this.inheritScope = null;
            } else {
                this.lookupOrder = ImCollections.newList((Object[])new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE});
                this.inheritScope = (IScopeContext)this.lookupOrder.get(1);
            }
            if (ManagedConfigurationBlock.this.project == null || this.hasProjectSpecificSettings(ManagedConfigurationBlock.this.project)) {
                this.disabledProjectSettings = null;
            } else {
                this.saveDisabledProjectSettings();
            }
            this.checkRebuild();
        }

        boolean hasProjectSpecificSettings(IProject project) {
            ProjectScope projectContext = new ProjectScope(project);
            for (Preference<?> pref : this.preferences.keySet()) {
                if (this.getInternalValue(pref, (IScopeContext)projectContext, true) == null) continue;
                return true;
            }
            return false;
        }

        void setUseProjectSpecificSettings(boolean enable) {
            boolean hasProjectSpecificOption;
            boolean bl = hasProjectSpecificOption = this.disabledProjectSettings == null;
            if (enable != hasProjectSpecificOption) {
                if (enable) {
                    this.loadDisabledProjectSettings();
                } else {
                    this.saveDisabledProjectSettings();
                }
            }
        }

        private void saveDisabledProjectSettings() {
            this.disabledProjectSettings = new IdentityHashMap();
            for (Preference<?> pref : this.preferences.keySet()) {
                this.disabledProjectSettings.put(pref, this.getValue(pref));
                this.setInternalValue(pref, null);
            }
        }

        private void loadDisabledProjectSettings() {
            for (Preference<?> key : this.preferences.keySet()) {
                this.setValue(key, this.disabledProjectSettings.get(key));
            }
            this.disabledProjectSettings = null;
        }

        boolean processChanges(boolean saveStore) {
            String[] strings;
            ArrayList changedPrefs = new ArrayList();
            boolean needsBuild = this.getChanges(changedPrefs);
            if (changedPrefs.isEmpty()) {
                return true;
            }
            boolean doBuild = false;
            if (needsBuild && this.checkRebuild() && (strings = ManagedConfigurationBlock.this.getFullBuildDialogStrings(ManagedConfigurationBlock.this.getProject() == null)) != null) {
                MessageDialog messageDialog = new MessageDialog(ManagedConfigurationBlock.this.getShell(), strings[0], null, strings[1], 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
                int res = messageDialog.open();
                if (res == 0) {
                    doBuild = true;
                } else if (res != 1) {
                    return false;
                }
            }
            if (saveStore) {
                try {
                    this.manager.applyChanges();
                }
                catch (BackingStoreException e) {
                    ManagedConfigurationBlock.this.logSaveError(e);
                    return false;
                }
                if (doBuild) {
                    this.createRebuild().schedule();
                }
            } else if (doBuild) {
                ManagedConfigurationBlock.this.getContainer().registerUpdateJob(this.createRebuild());
            }
            HashSet<String> groupIds = new HashSet<String>();
            for (Preference preference : changedPrefs) {
                String groupId = this.preferences.get(preference);
                if (groupId == null) continue;
                groupIds.add(groupId);
            }
            ManagedConfigurationBlock.this.scheduleChangeNotification(groupIds, saveStore);
            return true;
        }

        private boolean getChanges(List<Preference<?>> changedSettings) {
            IScopeContext currContext = (IScopeContext)this.lookupOrder.get(0);
            boolean needsBuild = false;
            for (Preference<?> key : this.preferences.keySet()) {
                String oldValue = this.getInternalValue(key, currContext, false);
                String value = this.getInternalValue(key, currContext, true);
                if (value == null) {
                    if (oldValue == null) continue;
                    changedSettings.add(key);
                    needsBuild |= !oldValue.equals(this.getInternalValue(key, true));
                    continue;
                }
                if (value.equals(oldValue)) continue;
                changedSettings.add(key);
                needsBuild |= oldValue != null || !value.equals(this.getInternalValue(key, true));
                if (this.inheritScope == null || !value.equals(this.getInternalValue(key, this.inheritScope, false))) continue;
                IEclipsePreferences node = this.getNode(currContext, key.getQualifier(), true);
                node.remove(key.getKey());
            }
            return needsBuild;
        }

        void loadDefaults() {
            IScopeContext defaultScope = DefaultScope.INSTANCE;
            for (Preference<?> key : this.preferences.keySet()) {
                String defValue = this.getInternalValue(key, defaultScope, false);
                this.setInternalValue(key, defValue);
            }
        }

        private void testIfOptionsComplete() {
            for (Preference<?> key : this.preferences.keySet()) {
                if (this.getInternalValue(key, false) != null) continue;
                System.out.println("preference option missing: " + key + " (" + this.getClass().getName() + ')');
            }
        }

        private IEclipsePreferences getNode(IScopeContext context, String qualifier, boolean useWorkingCopy) {
            IEclipsePreferences node = context.getNode(qualifier);
            if (useWorkingCopy && context != DefaultScope.INSTANCE) {
                return this.manager.getWorkingCopy(node);
            }
            return node;
        }

        private String getInternalValue(Preference<?> pref, IScopeContext context, boolean useWorkingCopy) {
            IEclipsePreferences node = this.getNode(context, pref.getQualifier(), useWorkingCopy);
            return node.get(pref.getKey(), null);
        }

        private String getInternalValue(Preference<?> pref, boolean ignoreTopScope) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < this.lookupOrder.size()) {
                String value = this.getInternalValue(pref, (IScopeContext)this.lookupOrder.get(i), true);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        private <T> void setInternalValue(Preference<T> pref, String value) {
            IEclipsePreferences node = this.getNode((IScopeContext)this.lookupOrder.get(0), pref.getQualifier(), true);
            if (value != null) {
                node.put(pref.getKey(), value);
            } else {
                node.remove(pref.getKey());
            }
        }

        private <T> void setValue(Preference<T> pref, T value) {
            String storeValue;
            IEclipsePreferences node = this.getNode((IScopeContext)this.lookupOrder.get(0), pref.getQualifier(), true);
            if (value == null || (storeValue = pref.usage2Store(value)) == null) {
                node.remove(pref.getKey());
                return;
            }
            node.put(pref.getKey(), storeValue);
        }

        private <T> T getValue(Preference<T> pref) {
            IEclipsePreferences node = null;
            int i = 0;
            while (i < this.lookupOrder.size()) {
                IEclipsePreferences nodeToCheck = this.getNode((IScopeContext)this.lookupOrder.get(i), pref.getQualifier(), true);
                if (nodeToCheck.get(pref.getKey(), null) != null) {
                    node = nodeToCheck;
                    break;
                }
                ++i;
            }
            String storeValue = node != null ? node.get(pref.getKey(), null) : null;
            return (T)pref.store2Usage(storeValue);
        }

        private boolean checkRebuild() {
            int counter = this.manager.getWorkingCopy(DefaultScope.INSTANCE.getNode(ManagedConfigurationBlock.REBUILD_QUALIFIER)).getInt(ManagedConfigurationBlock.REBUILD_KEY, 0);
            if (counter > this.rebuildCounter) {
                this.rebuildCounter = counter;
                return false;
            }
            return true;
        }

        private Job createRebuild() {
            ++this.rebuildCounter;
            this.manager.getWorkingCopy(DefaultScope.INSTANCE.getNode(ManagedConfigurationBlock.REBUILD_QUALIFIER)).putInt(ManagedConfigurationBlock.REBUILD_KEY, this.rebuildCounter);
            return BuildUtils.getBuildJob((IProject)ManagedConfigurationBlock.this.getProject());
        }
    }
}

