/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.ecommons.ui.Messages;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class DNDUtils {
    public static boolean setContent(Clipboard clipboard, Object[] datas, Transfer[] tranfers) {
        while (true) {
            try {
                clipboard.setContents(datas, tranfers);
                return true;
            }
            catch (SWTError e) {
                if (e.code == 2002) continue;
                throw e;
                if (MessageDialog.openQuestion((Shell)UIAccess.getActiveWorkbenchShell(true), (String)Messages.CopyToClipboard_error_title, (String)Messages.CopyToClipboard_error_message)) continue;
                return false;
            }
            break;
        }
    }

    public static void addDropSupport(Control control, DropTargetListener listener, Transfer[] transferTypes) {
        DNDUtils.addDropSupport(control, new DropTargetListener[]{listener}, 19, transferTypes);
    }

    public static void addDropSupport(Control control, DropTargetListener[] listeners, int operations, Transfer[] transferTypes) {
        DropTarget dropTarget = new DropTarget(control, operations);
        dropTarget.setTransfer(transferTypes);
        DropTargetListener[] dropTargetListenerArray = listeners;
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DropTargetListener listener = dropTargetListenerArray[n2];
            dropTarget.addDropListener(listener);
            ++n2;
        }
    }

    private DNDUtils() {
    }

    public static abstract class SimpleTextDropAdapter
    extends DropTargetAdapter {
        protected abstract StyledText getTextWidget();

        public void dragEnter(DropTargetEvent e) {
            if (e.detail == 16 && (e.operations & 1) != 0) {
                e.detail = 1;
            }
        }

        public void dragOperationChanged(DropTargetEvent e) {
            if (e.detail == 16 && (e.operations & 1) != 0) {
                e.detail = 1;
            }
        }

        public void dragOver(DropTargetEvent event) {
            event.feedback = 9;
        }

        public void drop(DropTargetEvent e) {
            this.getTextWidget().insert((String)e.data);
        }
    }
}

