/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing.operations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;

public abstract class AbstractLaunchConfigOperation
extends DocProcessingOperation {
    protected static final String LAUNCH_CONFIG_NAME_ATTR_KEY = "LaunchConfig.name";
    private final String launchConfigTypeId;
    private final String launchConfigNameAttrName;
    private ILaunchManager launchManager;
    private ILaunchConfigurationType launchConfigType;
    private ILaunchConfiguration launchConfig;

    public AbstractLaunchConfigOperation(String launchConfigTypeId) {
        this.launchConfigTypeId = launchConfigTypeId;
        this.launchConfigNameAttrName = String.valueOf(this.getId()) + '/' + LAUNCH_CONFIG_NAME_ATTR_KEY;
    }

    @Override
    public void init(DocProcessingToolConfig.StepConfig stepConfig, Map<String, String> settings, SubMonitor m) throws CoreException {
        super.init(stepConfig, settings, m);
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.launchConfigType = this.launchManager.getLaunchConfigurationType(this.launchConfigTypeId);
        if (this.launchConfigType == null) {
            throw new RuntimeException("Launch configuration type is missing: id= " + this.launchConfigTypeId);
        }
        String name = settings.get(this.launchConfigNameAttrName);
        if (name == null || name.isEmpty()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", Messages.ProcessingOperation_RunLaunchConfig_Config_error_SpecMissing_message));
        }
        ILaunchConfiguration orgConfig = LaunchUtils.findLaunchConfiguration((ILaunchConfiguration[])this.launchManager.getLaunchConfigurations(), (ILaunchConfigurationType)this.launchConfigType, (String)name);
        if (orgConfig == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", NLS.bind((String)Messages.ProcessingOperation_RunLaunchConfig_Config_error_DefMissing_message, (Object)name)));
        }
        this.launchConfig = this.preprocessConfig(orgConfig);
    }

    protected String getLaunchMode() {
        return "run";
    }

    @Override
    public IStatus run(DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        ILaunchConfiguration config = this.launchConfig;
        if (config == null) {
            throw new NullPointerException("launchConfig");
        }
        m.beginTask(this.getTaskLabel(config), 11);
        String launchMode = this.getLaunchMode();
        ILaunchConfigurationDelegate delegate = LaunchUtils.getLaunchConfigurationDelegate((ILaunchConfiguration)config, (String)launchMode, (MultiStatus)toolProcess.getStatus());
        m.worked(1);
        this.launch(delegate, config, launchMode, toolProcess, m.newChild(10));
        return Status.OK_STATUS;
    }

    protected String getTaskLabel(ILaunchConfiguration config) {
        DocProcessingToolConfig.StepConfig stepConfig = this.getStepConfig();
        if (stepConfig.getId() == "org.eclipse.statet.docmlet.base/preview") {
            return NLS.bind((String)Messages.ProcessingOperation_RunLaunchConfig_ForPreview_task, (Object)config.getName(), (Object)stepConfig.getInputFile().getName());
        }
        return NLS.bind((String)Messages.ProcessingOperation_RunLaunchConfig_task, (Object)config.getName());
    }

    protected VariableText2 createVariableResolver() {
        HashMap variables = new HashMap();
        variables.putAll(this.getStepConfig().getVariableResolver().getExtraVariables());
        return new VariableText2(variables);
    }

    protected ILaunchConfiguration preprocessConfig(ILaunchConfiguration config) throws CoreException {
        return config;
    }

    protected void launch(ILaunchConfigurationDelegate delegate, ILaunchConfiguration config, String launchMode, DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        delegate.launch(config, launchMode, toolProcess.getLaunch(), (IProgressMonitor)m);
    }
}

