/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui.markuphelp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.base.ui.markuphelp.IMarkupHelpContentProvider;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContent;
import org.eclipse.ui.statushandlers.StatusManager;

public class MarkupHelpManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.statet.docmlet.MarkupHelp";
    private static final String CONTENT_PROVIDER_ELEMENT_NAME = "contentProvider";
    private static final String CLASS_ATTR_NAME = "class";
    private static final Comparator<MarkupHelpContent> CONTENT_UI_COMPARATOR = new Comparator<MarkupHelpContent>(){

        @Override
        public int compare(MarkupHelpContent o1, MarkupHelpContent o2) {
            return o1.getTitle().compareTo(o2.getTitle());
        }
    };
    private Map<String, MarkupHelpContent> idContents;
    private List<MarkupHelpContent> topics;

    public MarkupHelpManager() {
        this.loadContributions();
    }

    private void loadContributions() {
        IConfigurationElement[] elements;
        HashMap<String, MarkupHelpContent> map = new HashMap<String, MarkupHelpContent>();
        ArrayList<MarkupHelpContent> topics = new ArrayList<MarkupHelpContent>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(CONTENT_PROVIDER_ELEMENT_NAME)) {
                try {
                    IMarkupHelpContentProvider contentProvider = (IMarkupHelpContentProvider)element.createExecutableExtension(CLASS_ATTR_NAME);
                    Collection<MarkupHelpContent> providedTopics = contentProvider.getHelpTopics();
                    for (MarkupHelpContent content : providedTopics) {
                        map.put(content.getId(), content);
                        topics.add(content);
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", 0, "An error occurred when loading markup help contentProvider.", (Throwable)e));
                }
            }
            ++n2;
        }
        Collections.sort(topics, CONTENT_UI_COMPARATOR);
        this.idContents = map;
        this.topics = Collections.unmodifiableList(topics);
    }

    public List<MarkupHelpContent> getTopicList() {
        return this.topics;
    }

    public MarkupHelpContent getContent(String id) {
        return this.idContents.get(id);
    }

    public synchronized void disable(String id) {
        MarkupHelpContent content = this.idContents.remove(id);
        if (content != null) {
            ArrayList<MarkupHelpContent> topics = new ArrayList<MarkupHelpContent>(this.topics);
            topics.remove(content);
            this.topics = Collections.unmodifiableList(topics);
        }
    }
}

