/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.IMarkerPositionResolver;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.SourceDocumentRunnable;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.model.core.impl.AbstractFilePersistenceSourceUnitFactory;
import org.eclipse.statet.ltk.model.core.impl.IWorkingBuffer;
import org.eclipse.statet.ltk.model.core.impl.WorkingBuffer;

public abstract class GenericResourceSourceUnit
implements IWorkspaceSourceUnit {
    private final String id;
    private final ElementName name;
    private final IFile file;
    private IWorkingBuffer buffer;
    private int counter = 0;

    public static String createResourceId(IResource file) {
        return AbstractFilePersistenceSourceUnitFactory.createResourceId(file);
    }

    public GenericResourceSourceUnit(String id, IFile file) {
        if (file == null) {
            throw new NullPointerException("file");
        }
        this.id = id;
        this.file = file;
        this.name = this.createElementName();
    }

    protected ElementName createElementName() {
        return new ElementName(){

            @Override
            public int getType() {
                return 17;
            }

            @Override
            public String getDisplayName() {
                return GenericResourceSourceUnit.this.file.getName();
            }

            @Override
            public String getSegmentName() {
                return GenericResourceSourceUnit.this.file.getName();
            }

            @Override
            public ElementName getNextSegment() {
                return null;
            }
        };
    }

    @Override
    public ISourceUnit getUnderlyingUnit() {
        return null;
    }

    @Override
    public boolean isSynchronized() {
        return true;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public WorkingContext getWorkingContext() {
        return LTK.PERSISTENCE_CONTEXT;
    }

    @Override
    public int getElementType() {
        return 528;
    }

    @Override
    public final ElementName getElementName() {
        return this.name;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public final IResource getResource() {
        return this.file;
    }

    @Override
    public IMarkerPositionResolver getMarkerPositionResolver() {
        return null;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return this.buffer.checkState(validate, monitor);
    }

    @Override
    public AbstractDocument getDocument(IProgressMonitor monitor) {
        return this.buffer.getDocument(monitor);
    }

    @Override
    public long getContentStamp(IProgressMonitor monitor) {
        return this.buffer.getContentStamp(monitor);
    }

    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        return this.buffer.getContent(monitor);
    }

    @Override
    public void syncExec(SourceDocumentRunnable runnable) throws InvocationTargetException {
        throw new UnsupportedOperationException();
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.equals(IResource.class)) {
            return (T)this.getResource();
        }
        return null;
    }

    @Override
    public AstInfo getAstInfo(String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ISourceUnitModelInfo getModelInfo(String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IModelElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            if (this.buffer == null) {
                this.buffer = new WorkingBuffer(this);
            }
            this.register();
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.buffer.releaseDocument((IProgressMonitor)m.newChild(1));
            this.unregister();
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected void register() {
    }

    protected void unregister() {
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ISourceUnit)) {
            return false;
        }
        ISourceUnit other = (ISourceUnit)obj;
        return this.getElementType() == other.getElementType() && this.getWorkingContext() == other.getWorkingContext() && this.getId().equals(other.getId()) && this.getModelTypeId().equals(other.getModelTypeId());
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

