/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.statet.ecommons.waltable.command.ILayerCommand;
import org.eclipse.statet.ecommons.waltable.coordinate.ILValueIterator;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionOutOfBoundsException;
import org.eclipse.statet.ecommons.waltable.edit.EditSelectionCommandHandler;
import org.eclipse.statet.ecommons.waltable.layer.ForwardLayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.layer.cell.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCellDim;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.statet.ecommons.waltable.selection.CellSelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.ClearAllSelectionsCommand;
import org.eclipse.statet.ecommons.waltable.selection.ISelectionModel;
import org.eclipse.statet.ecommons.waltable.selection.SelectAllCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectCellCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.SelectDimPositionsCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayerPainter;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayerStructuralChangeEventHandler;
import org.eclipse.statet.ecommons.waltable.selection.SelectionModel;
import org.eclipse.statet.ecommons.waltable.selection.config.DefaultSelectionLayerConfiguration;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;

public class SelectionLayer
extends ForwardLayer {
    public static final int MOVE_ALL = -1;
    public static final long NO_SELECTION = Long.MIN_VALUE;
    protected ISelectionModel selectionModel;
    protected ILayer underlyingLayer;
    protected final PositionCoordinate lastSelectedCell;
    protected final PositionCoordinate selectionAnchor;
    protected LRectangle lastSelectedRegion;
    private final SelectCellCommandHandler selectCellCommandHandler;
    private final SelectDimPositionsCommandHandler selectDimPositionsCommandHandler;

    public SelectionLayer(ILayer underlyingLayer) {
        this(underlyingLayer, null, true);
    }

    public SelectionLayer(ILayer underlyingLayer, boolean useDefaultConfiguration) {
        this(underlyingLayer, null, useDefaultConfiguration);
    }

    public SelectionLayer(ILayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration) {
        this(underlyingLayer, selectionModel, useDefaultConfiguration, true);
    }

    public SelectionLayer(ILayer underlyingLayer, ISelectionModel selectionModel, boolean useDefaultConfiguration, boolean registerDefaultEventHandler) {
        super(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.setLayerPainter(new SelectionLayerPainter());
        this.selectionModel = selectionModel != null ? selectionModel : new SelectionModel(this);
        this.lastSelectedCell = new PositionCoordinate(this, Long.MIN_VALUE, Long.MIN_VALUE);
        this.selectionAnchor = new PositionCoordinate(this, Long.MIN_VALUE, Long.MIN_VALUE);
        this.selectCellCommandHandler = new SelectCellCommandHandler(this);
        this.selectDimPositionsCommandHandler = new SelectDimPositionsCommandHandler(this);
        this.registerCommandHandlers();
        if (registerDefaultEventHandler) {
            this.registerEventHandler(new SelectionLayerStructuralChangeEventHandler(this, this.selectionModel));
        }
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultSelectionLayerConfiguration());
        }
    }

    public ISelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ISelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    @Override
    public ILayerPainter getLayerPainter() {
        return this.layerPainter;
    }

    protected void addSelection(LRectangle selection) {
        if (selection != this.lastSelectedRegion) {
            this.selectionAnchor.columnPosition = this.lastSelectedCell.columnPosition;
            this.selectionAnchor.rowPosition = this.lastSelectedCell.rowPosition;
            this.lastSelectedRegion = selection;
        }
        this.selectionModel.addSelection(selection);
    }

    public void clear() {
        this.clearSelections();
        this.fireLayerEvent(new CellSelectionEvent(this, Long.MIN_VALUE, Long.MIN_VALUE, false));
    }

    protected void resetLastSelection() {
        this.lastSelectedCell.columnPosition = Long.MIN_VALUE;
        this.lastSelectedCell.rowPosition = Long.MIN_VALUE;
        this.lastSelectedRegion = null;
    }

    protected void clearSelections() {
        this.selectionModel.clearSelection();
        this.resetLastSelection();
        this.selectionAnchor.columnPosition = -1L;
        this.selectionAnchor.rowPosition = -1L;
    }

    protected void clearSelection(long columnPosition, long rowPosition) {
        this.selectionModel.clearSelection(columnPosition, rowPosition);
        this.resetLastSelection();
    }

    protected void clearSelection(LRectangle selection) {
        this.selectionModel.clearSelection(selection);
        this.resetLastSelection();
    }

    public void selectAll() {
        LRectangle selection = new LRectangle(0L, 0L, this.getColumnCount(), this.getRowCount());
        if (this.lastSelectedCell.columnPosition == Long.MIN_VALUE || this.lastSelectedCell.rowPosition == Long.MIN_VALUE) {
            this.lastSelectedCell.rowPosition = 0L;
            this.lastSelectedCell.columnPosition = 0L;
        }
        this.addSelection(selection);
        this.fireCellSelectionEvent(this.lastSelectedCell.columnPosition, this.lastSelectedCell.rowPosition, false);
    }

    public boolean isCellPositionSelected(long columnPosition, long rowPosition) {
        ILayerCell cell = this.getCellByPosition(columnPosition, rowPosition);
        return cell != null && cell.getDisplayMode() == DisplayMode.SELECT;
    }

    public void setSelectedCell(long columnPosition, long rowPosition) {
        this.selectCell(columnPosition, rowPosition, 0);
    }

    public List<PositionCoordinate> getSelectedCellPositions() {
        LRangeList selectedColumnPositions = this.getSelectedColumnPositions();
        LRangeList selectedRowPositions = this.getSelectedRowPositions();
        ArrayList<PositionCoordinate> selectedCells = new ArrayList<PositionCoordinate>();
        ILValueIterator columnIter = selectedColumnPositions.values().iterator();
        while (columnIter.hasNext()) {
            long columnPosition = columnIter.nextValue();
            ILValueIterator rowIter = selectedRowPositions.values().iterator();
            while (rowIter.hasNext()) {
                long rowPosition = rowIter.nextValue();
                if (!this.isCellPositionSelected(columnPosition, rowPosition)) continue;
                selectedCells.add(new PositionCoordinate(this, columnPosition, rowPosition));
            }
        }
        return selectedCells;
    }

    public Collection<ILayerCell> getSelectedCells() {
        HashSet<ILayerCell> selectedCells = new HashSet<ILayerCell>();
        List<PositionCoordinate> selectedCoords = this.getSelectedCellPositions();
        for (PositionCoordinate coord : selectedCoords) {
            selectedCells.add(this.getCellByPosition(coord.columnPosition, coord.rowPosition));
        }
        return selectedCells;
    }

    public void selectCell(long columnPosition, long rowPosition, int selectionFlags) {
        this.selectCellCommandHandler.selectCell(columnPosition, rowPosition, selectionFlags, false);
    }

    public void selectRegion(long startColumnPosition, long startRowPosition, long regionWidth, long regionHeight) {
        if (this.lastSelectedRegion == null) {
            this.lastSelectedRegion = new LRectangle(startColumnPosition, startRowPosition, regionWidth, regionHeight);
        } else {
            this.lastSelectedRegion.x = startColumnPosition;
            this.lastSelectedRegion.y = startRowPosition;
            this.lastSelectedRegion.width = regionWidth;
            this.lastSelectedRegion.height = regionHeight;
        }
        this.selectionModel.addSelection(new LRectangle(this.lastSelectedRegion.x, this.lastSelectedRegion.y, this.lastSelectedRegion.width, this.lastSelectedRegion.height));
    }

    public PositionCoordinate getSelectionAnchor() {
        return this.selectionAnchor;
    }

    public void setSelectionAnchor(long columnPosition, long rowPosition, boolean revealCell) {
        long previousColumnPosition = this.selectionAnchor.columnPosition;
        long previousRowPosition = this.selectionAnchor.rowPosition;
        if (columnPosition == Long.MIN_VALUE || rowPosition == Long.MIN_VALUE) {
            this.selectionAnchor.columnPosition = Long.MIN_VALUE;
            this.selectionAnchor.rowPosition = Long.MIN_VALUE;
            this.resetLastSelection();
            if (previousColumnPosition != Long.MIN_VALUE) {
                // empty if block
            }
            return;
        }
        if (columnPosition < 0L || columnPosition >= this.getColumnCount() || rowPosition < 0L || rowPosition >= this.getRowCount()) {
            throw new PositionOutOfBoundsException(String.valueOf(columnPosition) + ", " + rowPosition);
        }
        this.selectionAnchor.columnPosition = columnPosition;
        this.selectionAnchor.rowPosition = rowPosition;
        this.resetLastSelection();
        this.fireLayerEvent(new CellSelectionEvent(this, columnPosition, rowPosition, revealCell));
    }

    public PositionCoordinate getLastSelectedCellPosition() {
        if (this.lastSelectedCell.columnPosition != Long.MIN_VALUE && this.lastSelectedCell.rowPosition != Long.MIN_VALUE) {
            return this.lastSelectedCell;
        }
        return this.selectionAnchor;
    }

    public boolean hasColumnSelection() {
        return this.lastSelectedCell.columnPosition != Long.MIN_VALUE;
    }

    public LRangeList getSelectedColumnPositions() {
        return this.selectionModel.getSelectedColumnPositions();
    }

    public boolean isColumnPositionSelected(long columnPosition) {
        return this.selectionModel.isColumnPositionSelected(columnPosition);
    }

    public LRangeList getFullySelectedColumnPositions() {
        return this.selectionModel.getFullySelectedColumnPositions();
    }

    public boolean isColumnPositionFullySelected(long columnPosition) {
        return this.selectionModel.isColumnPositionFullySelected(columnPosition);
    }

    public boolean hasRowSelection() {
        return this.lastSelectedCell.rowPosition != Long.MIN_VALUE;
    }

    public long getSelectedRowCount() {
        return this.selectionModel.getSelectedRowCount();
    }

    public LRangeList getSelectedRowPositions() {
        return this.selectionModel.getSelectedRowPositions();
    }

    public boolean isRowPositionSelected(long rowPosition) {
        return this.selectionModel.isRowPositionSelected(rowPosition);
    }

    public LRangeList getFullySelectedRowPositions() {
        return this.selectionModel.getFullySelectedRowPositions();
    }

    public boolean isRowPositionFullySelected(long rowPosition) {
        return this.selectionModel.isRowPositionFullySelected(rowPosition);
    }

    public LRangeList getSelectedPositions(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.selectionModel.getSelectedColumnPositions() : this.selectionModel.getSelectedRowPositions();
    }

    public boolean isPositionSelected(Orientation orientation, long position) {
        return orientation == Orientation.HORIZONTAL ? this.selectionModel.isColumnPositionSelected(position) : this.selectionModel.isRowPositionSelected(position);
    }

    public LRangeList getFullySelectedPositions(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? this.selectionModel.getFullySelectedColumnPositions() : this.selectionModel.getFullySelectedRowPositions();
    }

    public boolean isPositionFullySelected(Orientation orientation, long position) {
        return orientation == Orientation.HORIZONTAL ? this.selectionModel.isColumnPositionFullySelected(position) : this.selectionModel.isRowPositionFullySelected(position);
    }

    @Override
    protected ILayerCell createCell(ILayerCellDim hDim, ILayerCellDim vDim, ILayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public DisplayMode getDisplayMode() {
                if (SelectionLayer.this.selectionModel.isCellPositionSelected(this)) {
                    return DisplayMode.SELECT;
                }
                return super.getDisplayMode();
            }

            @Override
            public LabelStack getConfigLabels() {
                LabelStack configLabels = super.getConfigLabels();
                LRectangle cellRectangle = new LRectangle(this.getOriginColumnPosition(), this.getOriginRowPosition(), this.getColumnSpan(), this.getRowSpan());
                if (cellRectangle.contains(SelectionLayer.this.selectionAnchor.columnPosition, SelectionLayer.this.selectionAnchor.rowPosition)) {
                    configLabels.addLabel("selectionAnchor");
                }
                return configLabels;
            }
        };
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(this.selectCellCommandHandler);
        this.registerCommandHandler(this.selectDimPositionsCommandHandler);
        this.registerCommandHandler(new EditSelectionCommandHandler(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof SelectAllCommand && command.cloneCommand().convertToTargetLayer(this)) {
            this.selectAll();
            return true;
        }
        if (command instanceof ClearAllSelectionsCommand && command.cloneCommand().convertToTargetLayer(this)) {
            this.clear();
            return true;
        }
        return super.doCommand(command);
    }

    protected void fireCellSelectionEvent(long columnPosition, long rowPosition, boolean forcingEntireCellIntoViewport) {
        this.fireLayerEvent(new CellSelectionEvent(this, columnPosition, rowPosition, forcingEntireCellIntoViewport));
    }
}

