/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.CompletionProposalWithOverwrite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class SimpleCompletionProposal
extends CompletionProposalWithOverwrite {
    private final String replacementString;
    private int cursorPosition = -1;

    public SimpleCompletionProposal(AssistInvocationContext context, String replacementString, int replacementOffset) {
        super(context, replacementOffset);
        this.replacementString = replacementString;
    }

    protected final String getReplacementString() {
        return this.replacementString;
    }

    protected final void setCursorPosition(int offset) {
        this.cursorPosition = offset;
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy");
    }

    public String getDisplayString() {
        return this.getReplacementString();
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public int getRelevance() {
        return 0;
    }

    @Override
    public String getSortingString() {
        return this.replacementString;
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        try {
            int replacementOffset = this.getReplacementOffset();
            String content = document.get(replacementOffset, offset - replacementOffset);
            if (this.replacementString.regionMatches(true, 0, content, 0, content.length())) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void apply(IDocument document) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        AssistInvocationContext context = this.getInvocationContext();
        SourceViewer viewer = context.getSourceViewer();
        IDocument document = viewer.getDocument();
        try {
            String replacementString = this.getReplacementString();
            document.replace(replacementOffset, replacementLength, replacementString);
            this.setCursorPosition(replacementOffset + replacementString.length());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public Point getSelection(IDocument document) {
        if (this.cursorPosition >= 0) {
            return new Point(this.cursorPosition, 0);
        }
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

