/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.runtime;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.nico.core.Messages;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.nico.core.runtime.ILogOutput;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;

public class ToolRunner {
    public static boolean captureLogOnly(ILaunchConfiguration configuration) {
        try {
            return !configuration.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", true) && configuration.getAttribute("org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE", null) == null;
        }
        catch (CoreException e) {
            return true;
        }
    }

    public static IStatus createOutputLogStatus(ILogOutput log) {
        String s;
        if (log != null && (s = log.getOutput()).length() > 0) {
            return new Status(1, "org.eclipse.statet.nico.core", "Process Error Log:", (Throwable)new Exception(s));
        }
        return null;
    }

    private void run(ToolProcess process) throws StatusException {
        ToolController controller = process.getController();
        controller.run();
    }

    public <WorkspaceType extends ToolWorkspace> void runInBackgroundThread(final ToolProcess process, final IStatusHandler handler) {
        if (process == null || handler == null) {
            throw new NullPointerException();
        }
        Thread background = new Thread(){

            @Override
            public void run() {
                block11: {
                    try {
                        ToolRunner.this.run(process);
                    }
                    catch (StatusException e) {
                        if (e.getStatus() == null || e.getStatus().getSeverity() != 8) {
                            process.setExitValue(197121);
                            IStatus status = ToolRunner.this.createStatus(process, NLS.bind((String)Messages.Runtime_error_UnexpectedTermination_message, (Object[])new Object[]{process.getLabel(0), process.getLabel()}), e);
                            try {
                                handler.handleStatus(status, null);
                            }
                            catch (CoreException e1) {
                                NicoCorePlugin.log(status);
                                NicoCorePlugin.logError(105, Messages.ErrorHandling_error_message, e1);
                            }
                        }
                    }
                    catch (Throwable e) {
                        process.setExitValue(197122);
                        IStatus status = ToolRunner.this.createStatus(process, NLS.bind((String)Messages.Runtime_error_CriticalError_message, (Object)this.getName()), e);
                        try {
                            handler.handleStatus(status, null);
                        }
                        catch (CoreException e1) {
                            NicoCorePlugin.log(status);
                            NicoCorePlugin.logError(105, Messages.ErrorHandling_error_message, e1);
                        }
                        IStatus logStatus = ToolRunner.createOutputLogStatus((ILogOutput)process.getAdapter(ILogOutput.class));
                        if (logStatus == null) break block11;
                        NicoCorePlugin.log(status);
                    }
                }
                try {
                    ILaunch launch = process.getLaunch();
                    if (launch != null && !launch.isTerminated()) {
                        launch.isTerminated();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        background.setDaemon(true);
        background.setName(String.valueOf(process.getMainType()) + " Engine '" + process.getLabel() + "'");
        background.start();
    }

    private IStatus createStatus(ToolProcess process, String message, Throwable e) {
        ArrayList<IStatus> list = new ArrayList<IStatus>();
        IProcess[] processes = process.getLaunch().getProcesses();
        int i = 0;
        while (i < processes.length) {
            IStatus logStatus = ToolRunner.createOutputLogStatus((ILogOutput)processes[i].getAdapter(ILogOutput.class));
            if (logStatus != null) {
                list.add(logStatus);
            }
            ++i;
        }
        if (list.isEmpty()) {
            return new Status(4, "org.eclipse.statet.nico.core", 0, message, e);
        }
        return new MultiErrorStatus("org.eclipse.statet.nico.core", 197120, list.toArray(new IStatus[list.size()]), message, e);
    }

    private static class MultiErrorStatus
    extends Status {
        private final IStatus[] children;

        public MultiErrorStatus(String pluginId, int code, IStatus[] children, String message, Throwable exception) {
            super(4, pluginId, code, message, exception);
            this.children = children;
        }

        public boolean isMultiStatus() {
            return true;
        }

        public IStatus[] getChildren() {
            return this.children;
        }
    }
}

