/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.buildpaths.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.viewers.TypedViewerFilter;
import org.eclipse.statet.ecommons.ui.workbench.workspace.AbstractResourceSelectionDialog;
import org.eclipse.statet.internal.ltk.buildpaths.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElement;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathsUIDescription;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class ExclusionInclusionEntryDialog
extends ExtStatusDialog {
    private static final ImList<Class<?>> ACCEPTED_CLASSES = ImCollections.newList((Object[])new Class[]{IFolder.class, IFile.class});
    private final BuildpathsUIDescription uiDescription;
    private final BuildpathListElement element;
    private final String attributeKey;
    private IContainer elementSourceFolder;
    private final IPath originalPattern;
    private final List<IPath> existingPatterns;
    private IPath pattern;
    private Text patternControl;
    private final StatusInfo patternStatus;

    static List<IPath> chooseExclusionPattern(Shell shell, IContainer sourceFolder, String title, String message, IPath initialPath, boolean multiSelection) {
        TypedViewerFilter filter = new TypedViewerFilter(ACCEPTED_CLASSES);
        IResource initialElement = AbstractResourceSelectionDialog.findExistingResource((IPath)initialPath, (IContainer)sourceFolder);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setAllowMultiple(multiSelection);
        dialog.setInput((Object)sourceFolder);
        dialog.setInitialSelection((Object)initialElement);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            int existingSegments = sourceFolder.getFullPath().segmentCount();
            ArrayList<IPath> result = new ArrayList<IPath>(objects.length);
            int i = 0;
            while (i < objects.length) {
                IResource currRes = (IResource)objects[i];
                IPath path = currRes.getFullPath().removeFirstSegments(existingSegments).makeRelative();
                if (currRes instanceof IContainer) {
                    path = path.addTrailingSeparator();
                }
                result.add(path);
                ++i;
            }
            return result;
        }
        return null;
    }

    public ExclusionInclusionEntryDialog(Shell parent, BuildpathListElement element, String attributeKey, IPath patternToEdit, List<IPath> existingPatterns, BuildpathsUIDescription uiDescription) {
        super(parent);
        String title;
        this.uiDescription = uiDescription;
        this.element = element;
        this.attributeKey = attributeKey;
        this.originalPattern = patternToEdit;
        this.existingPatterns = existingPatterns;
        IWorkspaceRoot root = this.element.getProject().getWorkspace().getRoot();
        IResource res = root.findMember(this.element.getPath());
        if (res instanceof IContainer) {
            this.elementSourceFolder = (IContainer)res;
        }
        switch (attributeKey) {
            case "Filter.inclusions": {
                title = patternToEdit == null ? Messages.ExclusionInclusion_EntryDialog_Include_Add_title : Messages.ExclusionInclusion_EntryDialog_Include_Edit_title;
                break;
            }
            case "Filter.exclusions": {
                title = patternToEdit == null ? Messages.ExclusionInclusion_EntryDialog_Exclude_Add_title : Messages.ExclusionInclusion_EntryDialog_Exclude_Edit_title;
                break;
            }
            default: {
                throw new IllegalArgumentException(attributeKey);
            }
        }
        this.setTitle(title);
        this.patternStatus = new StatusInfo();
    }

    public void create() {
        super.create();
        this.updateTargets();
    }

    protected Control createDialogArea(Composite parent) {
        String labelText;
        String descriptionText;
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        switch (this.attributeKey) {
            case "Filter.inclusions": {
                descriptionText = NLS.bind((String)Messages.ExclusionInclusion_EntryDialog_Exclude_description, (Object)this.uiDescription.getDefaultExt(this.element));
                labelText = NLS.bind((String)Messages.ExclusionInclusion_EntryDialog_Exclude_Pattern_label, (Object)MessageUtils.processPath((String)this.element.getPath().toString()));
                break;
            }
            case "Filter.exclusions": {
                descriptionText = NLS.bind((String)Messages.ExclusionInclusion_EntryDialog_Include_description, (Object)this.uiDescription.getDefaultExt(this.element));
                labelText = NLS.bind((String)Messages.ExclusionInclusion_EntryDialog_Include_Pattern_label, (Object)MessageUtils.processPath((String)this.element.getPath().toString()));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Label description = new Label(area, 64);
        description.setText(descriptionText);
        GridData gd = new GridData(4, 128, true, false, 2, 1);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        description.setLayoutData((Object)gd);
        Composite composite = area;
        Label label = new Label(area, 0);
        label.setText(labelText);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Text text = new Text(area, 2048);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)text, (int)60);
        text.setLayoutData((Object)gd2);
        this.patternControl = text;
        Button button = new Button(area, 8);
        button.setText(Messages.ExclusionInclusion_EntryDialog_Choose_label);
        button.setEnabled(this.elementSourceFolder != null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath pattern = ExclusionInclusionEntryDialog.this.doBrowsePattern();
                if (pattern != null) {
                    ExclusionInclusionEntryDialog.this.patternControl.setText(pattern.toString());
                    ExclusionInclusionEntryDialog.this.update();
                }
            }
        });
        gd2 = new GridData(4, 4, false, false);
        gd2.widthHint = LayoutUtils.hintWidth((Button)button);
        button.setLayoutData((Object)gd2);
        ExclusionInclusionEntryDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private IPath doBrowsePattern() {
        String message;
        String title;
        switch (this.attributeKey) {
            case "Filter.inclusions": {
                title = Messages.ExclusionInclusion_Choose_Include_title;
                message = Messages.ExclusionInclusion_Choose_Include_Single_description;
                break;
            }
            case "Filter.exclusions": {
                title = Messages.ExclusionInclusion_Choose_Exclude_title;
                message = Messages.ExclusionInclusion_Choose_Exclude_Single_description;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Path initialPath = new Path(this.patternControl.getText());
        List<IPath> patterns = ExclusionInclusionEntryDialog.chooseExclusionPattern(this.getShell(), this.elementSourceFolder, title, message, (IPath)initialPath, false);
        if (patterns == null) {
            return null;
        }
        return patterns.get(0);
    }

    protected void updateTargets() {
        this.patternControl.setText(this.originalPattern != null ? this.originalPattern.toString() : "");
    }

    protected void update() {
        this.validate();
        this.updateStatus((IStatus)this.patternStatus);
    }

    protected void validate() {
        String pattern = this.patternControl.getText().trim();
        if (pattern.length() == 0) {
            this.patternStatus.setError(Messages.ExclusionInclusion_EntryDialog_error_Empty_message);
            return;
        }
        Path path = new Path(pattern);
        if (path.isAbsolute() || path.getDevice() != null) {
            this.patternStatus.setError(Messages.ExclusionInclusion_EntryDialog_error_NotRelative_message);
            return;
        }
        if (!path.equals((Object)this.originalPattern) && this.existingPatterns.contains(path)) {
            this.patternStatus.setError(Messages.ExclusionInclusion_EntryDialog_error_AlreadyExists_message);
            return;
        }
        this.pattern = path;
        this.patternStatus.setOK();
    }

    public IPath getPattern() {
        return this.pattern;
    }
}

