/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.parser;

import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;

public class LtxLexer {
    public static final byte EOF = -1;
    protected static final byte NONE = 0;
    public static final byte LINEBREAK = 1;
    public static final byte WHITESPACE = 2;
    public static final byte DEFAULT_TEXT = 3;
    public static final byte CONTROL_NONE = 4;
    public static final byte CONTROL_WORD = 5;
    public static final byte CONTROL_CHAR = 6;
    public static final byte ASTERISK = 8;
    public static final byte CURLY_BRACKET_OPEN = 9;
    public static final byte CURLY_BRACKET_CLOSE = 10;
    public static final byte SQUARED_BRACKET_OPEN = 11;
    public static final byte SQUARED_BRACKET_CLOSE = 12;
    public static final byte MATH_$ = 14;
    public static final byte MATH_$$ = 15;
    public static final byte LINE_COMMENT = 16;
    public static final byte VERBATIM_TEXT = 17;
    public static final byte EMBEDDED = 18;
    public static final byte SUB_OPEN_MISSING = 1;
    public static final byte SUB_CLOSE_MISSING = 2;
    protected static final byte S_DEFAULT = 0;
    protected static final byte S_VERBATIME_ENV = 1;
    protected static final byte S_VERBATIME_LINE = 2;
    protected static final byte S_EMBEDDED = 3;
    private TextParserInput input;
    private byte foundType;
    private int foundFlags;
    private int foundOffset;
    private int foundNum;
    private int foundLength;
    private String foundText;
    private boolean wasLinebreak;
    private byte state;
    private byte savedVerbatimState;
    private byte savedEmbeddedState;
    private char[] endPattern;
    private boolean reportSquaredBrackets = false;
    private boolean reportStars = false;
    private boolean report$$ = true;

    public LtxLexer(TextParserInput input) {
        this();
        this.reset(input);
    }

    public LtxLexer() {
    }

    public void reset() {
        this.foundType = 0;
        this.foundOffset = this.input.getIndex();
        this.foundNum = 0;
        this.foundLength = 0;
        this.reportSquaredBrackets = false;
        this.reportStars = false;
        this.report$$ = true;
    }

    public void reset(TextParserInput input) {
        this.input = input;
        this.reset();
    }

    public final TextParserInput getInput() {
        return this.input;
    }

    public void setReportAsterisk(boolean enable) {
        this.reportStars = enable;
    }

    public void setReportSquaredBrackets(boolean enable) {
        this.reportSquaredBrackets = enable;
    }

    public void setReport$$(boolean enable) {
        this.report$$ = enable;
    }

    public void setModeVerbatimEnv(char[] pattern) {
        this.state = 1;
        this.endPattern = pattern;
    }

    public void setModeVerbatimLine() {
        this.savedVerbatimState = this.state;
        this.state = (byte)2;
    }

    public final byte pop() {
        return this.foundType != 0 ? this.foundType : this.next();
    }

    public final void consume() {
        this.foundType = 0;
    }

    public final void consume(boolean clear) {
        if (clear) {
            this.input.consume(this.foundNum);
            this.foundOffset = this.input.getIndex();
            this.foundNum = 0;
            this.foundLength = 0;
        }
        this.foundType = 0;
    }

    public byte next() {
        this.foundType = 0;
        while (this.foundType == 0) {
            this.input.consume(this.foundNum);
            this.foundOffset = this.input.getIndex();
            if (this.wasLinebreak) {
                this.wasLinebreak = false;
                this.handleNewLine(this.foundOffset, 0);
            }
            switch (this.state) {
                case 0: {
                    this.searchDefault();
                    break;
                }
                case 1: {
                    this.searchVerbatimEnv();
                    break;
                }
                case 2: {
                    this.searchVerbatimLine();
                    break;
                }
                case 3: {
                    this.searchEmbedded();
                }
            }
        }
        return this.foundType;
    }

    public final int getType() {
        return this.foundType;
    }

    public final int getFlags() {
        return this.foundFlags;
    }

    public final int getOffset() {
        return this.foundOffset;
    }

    public final int getLength() {
        return this.foundLength;
    }

    public final int getStopOffset() {
        return this.foundOffset + this.foundLength;
    }

    public final String getText() {
        switch (this.foundType) {
            case -1: {
                return null;
            }
            case 1: {
                return "\n";
            }
            case 2: {
                return " ";
            }
            case 4: {
                return null;
            }
            case 6: {
                return this.wasLinebreak ? "\n" : this.input.getString(1, 1);
            }
            case 5: {
                return this.input.getString(1, this.foundNum - 1);
            }
            case 18: {
                return this.foundText;
            }
        }
        return null;
    }

    public final String getText(StringFactory textFactory) {
        switch (this.foundType) {
            case -1: {
                return null;
            }
            case 1: {
                return "\n";
            }
            case 2: {
                return " ";
            }
            case 4: {
                return null;
            }
            case 6: {
                return this.wasLinebreak ? "\n" : this.input.getString(1, 1, textFactory);
            }
            case 5: {
                return this.input.getString(1, this.foundNum - 1, textFactory);
            }
            case 18: {
                return this.foundText;
            }
        }
        return null;
    }

    public final String getFullText(StringFactory factory) {
        return this.input.getString(0, this.foundNum, factory);
    }

    protected int getNum() {
        return this.foundNum;
    }

    private void foundEOF(TextParserInput in) {
        this.foundType = (byte)-1;
        this.foundFlags = 0;
        this.foundNum = 0;
        this.foundLength = in.getLengthInSource(0);
    }

    private void foundLineComment(TextParserInput in, int n) {
        this.foundType = (byte)16;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundLinebreak(TextParserInput in, int n) {
        this.foundType = 1;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.wasLinebreak = true;
    }

    private void foundWhitespace(TextParserInput in, int n) {
        this.foundType = (byte)2;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundControlLinebreak(TextParserInput in, int n) {
        this.foundType = (byte)6;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.wasLinebreak = true;
    }

    private void found1(TextParserInput in, byte type) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundNum = 1;
        this.foundLength = in.getLengthInSource(1);
    }

    private void found2(TextParserInput in, byte type) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundNum = 2;
        this.foundLength = in.getLengthInSource(2);
    }

    private void found(TextParserInput in, byte type, int n) {
        this.foundType = type;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
    }

    private void foundVerbatimText(TextParserInput in, int n, byte newState) {
        this.foundType = (byte)17;
        this.foundFlags = 0;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.state = newState;
    }

    private void foundVerbatimText(TextParserInput in, byte flags, int n, byte newState) {
        this.foundType = (byte)17;
        this.foundFlags = flags;
        this.foundNum = n;
        this.foundLength = in.getLengthInSource(this.foundNum);
        this.state = newState;
    }

    protected void setEmbeddedBegin() {
        this.savedEmbeddedState = this.state;
        this.state = (byte)3;
    }

    protected void setEmbeddedEnd(int n, String text) {
        this.foundType = (byte)18;
        this.foundNum = n;
        this.foundLength = this.input.getLengthInSource(n);
        this.foundText = text;
        if (n > 0) {
            switch (this.input.get(n - 1)) {
                case 10: 
                case 13: {
                    this.wasLinebreak = true;
                }
            }
        }
        this.state = this.savedEmbeddedState;
    }

    protected final void searchDefault() {
        TextParserInput in = this.input;
        switch (in.get(0)) {
            case -1: {
                this.foundEOF(in);
                return;
            }
            case 13: {
                if (in.get(1) == 10) {
                    this.foundLinebreak(in, 2);
                    return;
                }
                this.foundLinebreak(in, 1);
                return;
            }
            case 10: {
                this.foundLinebreak(in, 1);
                return;
            }
            case 9: 
            case 12: 
            case 32: {
                int n = 1;
                block36: while (true) {
                    switch (in.get(n++)) {
                        case 9: 
                        case 32: {
                            continue block36;
                        }
                    }
                    break;
                }
                this.foundWhitespace(in, n - 1);
                return;
            }
            case 92: {
                switch (in.get(1)) {
                    case -1: {
                        this.found1(in, (byte)4);
                        return;
                    }
                    case 13: {
                        if (in.get(2) == 10) {
                            this.foundControlLinebreak(in, 3);
                            return;
                        }
                    }
                    case 10: {
                        this.foundControlLinebreak(in, 2);
                        return;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: {
                        int n = 2;
                        block37: while (true) {
                            switch (in.get(n++)) {
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: 
                                case 71: 
                                case 72: 
                                case 73: 
                                case 74: 
                                case 75: 
                                case 76: 
                                case 77: 
                                case 78: 
                                case 79: 
                                case 80: 
                                case 81: 
                                case 82: 
                                case 83: 
                                case 84: 
                                case 85: 
                                case 86: 
                                case 87: 
                                case 88: 
                                case 89: 
                                case 90: 
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: 
                                case 103: 
                                case 104: 
                                case 105: 
                                case 106: 
                                case 107: 
                                case 108: 
                                case 109: 
                                case 110: 
                                case 111: 
                                case 112: 
                                case 113: 
                                case 114: 
                                case 115: 
                                case 116: 
                                case 117: 
                                case 118: 
                                case 119: 
                                case 120: 
                                case 121: 
                                case 122: {
                                    continue block37;
                                }
                            }
                            break;
                        }
                        this.found(in, (byte)5, n - 1);
                        return;
                    }
                }
                this.found2(in, (byte)6);
                return;
            }
            case 42: {
                if (!this.reportStars) break;
                this.found1(in, (byte)8);
                return;
            }
            case 123: {
                this.found1(in, (byte)9);
                return;
            }
            case 125: {
                this.found1(in, (byte)10);
                return;
            }
            case 91: {
                if (!this.reportSquaredBrackets) break;
                this.found1(in, (byte)11);
                return;
            }
            case 93: {
                if (!this.reportSquaredBrackets) break;
                this.found1(in, (byte)12);
                return;
            }
            case 36: {
                if (this.report$$ && in.get(1) == 36) {
                    this.found2(in, (byte)15);
                    return;
                }
                this.found1(in, (byte)14);
                return;
            }
            case 37: {
                int n = 1;
                while (true) {
                    switch (in.get(n++)) {
                        case -1: {
                            this.foundLineComment(in, n - 1);
                            return;
                        }
                        case 13: {
                            if (in.get(n) == 10) {
                                ++n;
                            }
                        }
                        case 10: {
                            this.foundLineComment(in, n);
                            this.wasLinebreak = true;
                            return;
                        }
                    }
                }
            }
        }
        int n = 1;
        int tmp = 1;
        block39: while (true) {
            switch (in.get(tmp++)) {
                case -1: 
                case 10: 
                case 12: 
                case 13: 
                case 36: 
                case 37: 
                case 92: 
                case 123: 
                case 125: {
                    this.found(in, (byte)3, n);
                    return;
                }
                case 91: 
                case 93: {
                    if (!this.reportSquaredBrackets) continue block39;
                    this.found(in, (byte)3, n);
                    return;
                }
                case 9: 
                case 32: {
                    continue block39;
                }
            }
            n = tmp;
        }
    }

    protected final void searchVerbatimEnv() {
        TextParserInput in = this.input;
        int n = 1;
        block6: while (true) {
            switch (in.get(n++)) {
                case -1: {
                    this.foundVerbatimText(in, (byte)2, n - 1, (byte)0);
                    return;
                }
                case 13: {
                    if (in.get(n) == 10) {
                        // empty if block
                    }
                }
                case 10: {
                    this.foundNum = ++n;
                    this.foundLength = in.getLengthInSource(this.foundNum);
                    this.handleNewLine(this.foundOffset + this.foundLength, n);
                    if (this.state == 1) continue block6;
                    this.foundVerbatimText(in, n, this.state);
                    return;
                }
                case 92: {
                    if (!in.matches(n, this.endPattern)) continue block6;
                    this.foundVerbatimText(in, n - 1, (byte)0);
                    return;
                }
            }
        }
    }

    protected final void searchVerbatimLine() {
        int c;
        TextParserInput in = this.input;
        int end = in.get(0);
        if (end < 32) {
            this.foundVerbatimText(in, (byte)1, 0, this.savedVerbatimState);
            return;
        }
        int n = 1;
        do {
            c = in.get(n++);
            switch (c) {
                case -1: 
                case 10: 
                case 13: {
                    this.foundVerbatimText(in, (byte)2, n - 1, this.savedVerbatimState);
                    return;
                }
            }
        } while (c != end);
        this.foundVerbatimText(in, n, this.savedVerbatimState);
    }

    protected void searchEmbedded() {
    }

    protected void handleNewLine(int offset, int n) {
    }
}

