/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.Collection;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextElementName;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.impl.NameAccessAccumulator;

public abstract class RefLabelAccess
extends WikitextNameAccess {
    public static final int A_READ = 0;
    public static final int A_WRITE = 2;
    private final NameAccessAccumulator<WikitextNameAccess> shared;
    private final WikitextAstNode node;
    private final WikitextAstNode nameNode;
    int flags;

    protected RefLabelAccess(NameAccessAccumulator<WikitextNameAccess> shared, WikitextAstNode node, WikitextAstNode labelNode) {
        this.shared = shared;
        shared.getList().add(this);
        this.node = node;
        this.nameNode = labelNode;
    }

    public String getSegmentName() {
        return this.shared.getLabel();
    }

    public String getDisplayName() {
        return this.shared.getLabel();
    }

    @Override
    public WikitextElementName getNextSegment() {
        return null;
    }

    public WikitextAstNode getNode() {
        return this.node;
    }

    public WikitextAstNode getNameNode() {
        return this.nameNode;
    }

    public ImList<? extends WikitextNameAccess> getAllInUnit() {
        return ImCollections.toList((Collection)this.shared.getList());
    }

    public boolean isWriteAccess() {
        return (this.flags & 2) != 0;
    }

    static final class LinkAnchor
    extends RefLabelAccess {
        protected LinkAnchor(NameAccessAccumulator<WikitextNameAccess> shared, WikitextAstNode node, WikitextAstNode labelNode) {
            super(shared, node, labelNode);
        }

        public int getType() {
            return 65;
        }
    }

    static final class LinkDef
    extends RefLabelAccess {
        protected LinkDef(NameAccessAccumulator<WikitextNameAccess> shared, WikitextAstNode node, WikitextAstNode labelNode) {
            super(shared, node, labelNode);
        }

        public int getType() {
            return 69;
        }
    }
}

