/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.statet.docmlet.wikitext.core.ast.Block;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.ast.Heading;
import org.eclipse.statet.docmlet.wikitext.core.ast.Image;
import org.eclipse.statet.docmlet.wikitext.core.ast.Label;
import org.eclipse.statet.docmlet.wikitext.core.ast.Link;
import org.eclipse.statet.docmlet.wikitext.core.ast.SourceComponent;
import org.eclipse.statet.docmlet.wikitext.core.ast.Span;
import org.eclipse.statet.docmlet.wikitext.core.ast.Text;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.docmlet.wikitext.core.model.EmbeddingReconcileItem;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextElementName;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.RefLabelAccess;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikidocSourceUnitModelInfo;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikitextSourceElement;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.model.core.impl.BasicNameAccessSet;
import org.eclipse.statet.ltk.model.core.impl.NameAccessAccumulator;

public class SourceAnalyzer
extends WikitextAstVisitor {
    private static final Integer ONE = 1;
    private String input;
    private WikitextSourceElement.Container currentElement;
    private final StringBuilder titleBuilder = new StringBuilder();
    private boolean titleDoBuild;
    private WikitextSourceElement.Container titleElement;
    private final Map<String, Integer> structNamesCounter = new HashMap<String, Integer>();
    private final List<EmbeddingReconcileItem> embeddedItems = new ArrayList<EmbeddingReconcileItem>();
    private int minSectionLevel;
    private int maxSectionLevel;
    private Map<String, NameAccessAccumulator<WikitextNameAccess>> linkAnchorLabels = new HashMap<String, NameAccessAccumulator<WikitextNameAccess>>();
    private Map<String, NameAccessAccumulator<WikitextNameAccess>> linkDefLabels = new HashMap<String, NameAccessAccumulator<WikitextNameAccess>>();

    public void clear() {
        this.input = null;
        this.currentElement = null;
        this.titleBuilder.setLength(0);
        this.titleDoBuild = false;
        this.titleElement = null;
        this.embeddedItems.clear();
        this.minSectionLevel = Integer.MAX_VALUE;
        this.maxSectionLevel = Integer.MIN_VALUE;
    }

    public WikidocSourceUnitModelInfo createModel(WikitextSourceUnit su, String input, AstInfo ast) {
        this.clear();
        this.input = input;
        if (!(ast.getRoot() instanceof WikitextAstNode)) {
            return null;
        }
        if (!this.linkAnchorLabels.isEmpty()) {
            this.linkAnchorLabels.clear();
        }
        if (!this.linkDefLabels.isEmpty()) {
            this.linkDefLabels.clear();
        }
        this.currentElement = new WikitextSourceElement.SourceContainer(528, su, (WikitextAstNode)ast.getRoot());
        WikitextSourceElement.SourceContainer root = this.currentElement;
        try {
            BasicNameAccessSet linkDefLabels;
            BasicNameAccessSet linkAnchorLabels;
            ((WikitextAstNode)ast.getRoot()).acceptInWikitext(this);
            if (this.minSectionLevel == Integer.MAX_VALUE) {
                this.minSectionLevel = 0;
                this.maxSectionLevel = 0;
            }
            if (this.linkAnchorLabels.isEmpty()) {
                linkAnchorLabels = BasicNameAccessSet.emptySet();
            } else {
                linkAnchorLabels = new BasicNameAccessSet(this.linkAnchorLabels);
                this.linkAnchorLabels = new HashMap<String, NameAccessAccumulator<WikitextNameAccess>>();
            }
            if (this.linkDefLabels.isEmpty()) {
                linkDefLabels = BasicNameAccessSet.emptySet();
            } else {
                linkDefLabels = new BasicNameAccessSet(this.linkDefLabels);
                this.linkDefLabels = new HashMap<String, NameAccessAccumulator<WikitextNameAccess>>();
            }
            WikidocSourceUnitModelInfo model = new WikidocSourceUnitModelInfo(ast, root, (NameAccessSet<WikitextNameAccess>)linkAnchorLabels, (NameAccessSet<WikitextNameAccess>)linkDefLabels, this.minSectionLevel, this.maxSectionLevel);
            return model;
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException();
        }
    }

    public List<EmbeddingReconcileItem> getEmbeddedItems() {
        return this.embeddedItems;
    }

    private void initElement(WikitextSourceElement.Container element) {
        if (this.currentElement.children.isEmpty()) {
            this.currentElement.children = new ArrayList<WikitextSourceElement>();
        }
        this.currentElement.children.add(element);
        this.currentElement = element;
    }

    private void exitContainer(int stop, boolean forward) {
        this.currentElement.length = (forward ? this.readLinebreakForward(stop >= 0 ? stop : this.currentElement.startOffset + this.currentElement.length, this.input.length()) : this.readLinebreakBackward(stop >= 0 ? stop : this.currentElement.startOffset + this.currentElement.length, 0)) - this.currentElement.startOffset;
        List<WikitextSourceElement> children = this.currentElement.children;
        if (!children.isEmpty()) {
            for (WikitextSourceElement element : children) {
                if ((element.getElementType() & 0xFF0) != 1056) continue;
                Map<String, Integer> names = this.structNamesCounter;
                String name = element.getElementName().getDisplayName();
                Integer occ = names.get(name);
                if (occ == null) {
                    names.put(name, ONE);
                    continue;
                }
                element.occurrenceCount = occ + 1;
                names.put(name, element.occurrenceCount);
            }
            this.structNamesCounter.clear();
        }
        this.currentElement = this.currentElement.getModelParent();
    }

    private void finishTitleText() {
        boolean wasWhitespace = false;
        int idx = 0;
        while (idx < this.titleBuilder.length()) {
            if (this.titleBuilder.charAt(idx) == ' ') {
                if (wasWhitespace) {
                    this.titleBuilder.deleteCharAt(idx);
                    continue;
                }
                wasWhitespace = true;
                ++idx;
                continue;
            }
            wasWhitespace = false;
            ++idx;
        }
        this.titleElement.name = WikitextElementName.create(17, this.titleBuilder.toString());
        this.titleBuilder.setLength(0);
        this.titleElement = null;
        this.titleDoBuild = false;
    }

    private int readLinebreakForward(int offset, int limit) {
        if (offset < limit) {
            switch (this.input.charAt(offset)) {
                case '\n': {
                    if (++offset < limit && this.input.charAt(offset) == '\r') {
                        return ++offset;
                    }
                    return offset;
                }
                case '\r': {
                    if (++offset < limit && this.input.charAt(offset) == '\n') {
                        return ++offset;
                    }
                    return offset;
                }
            }
        }
        return offset;
    }

    private int readLinebreakBackward(int offset, int limit) {
        if (offset > limit) {
            switch (this.input.charAt(offset - 1)) {
                case '\n': {
                    if (--offset > limit && this.input.charAt(offset - 1) == '\r') {
                        return --offset;
                    }
                    return offset;
                }
                case '\r': {
                    if (--offset < limit && this.input.charAt(offset - 1) == '\n') {
                        return --offset;
                    }
                    return offset;
                }
            }
        }
        return offset;
    }

    private RefLabelAccess addLinkAnchorAccess(WikitextAstNode node) {
        String label = node.getLabel();
        NameAccessAccumulator shared = this.linkAnchorLabels.get(label);
        if (shared == null) {
            shared = new NameAccessAccumulator(label);
            this.linkAnchorLabels.put(label, (NameAccessAccumulator<WikitextNameAccess>)shared);
        }
        RefLabelAccess.LinkAnchor access = new RefLabelAccess.LinkAnchor((NameAccessAccumulator<WikitextNameAccess>)shared, node, null);
        node.addAttachment(access);
        return access;
    }

    private RefLabelAccess addLinkDefAccess(WikitextAstNode node, Label labelNode) {
        String label = labelNode.getText();
        NameAccessAccumulator shared = this.linkDefLabels.get(label);
        if (shared == null) {
            shared = new NameAccessAccumulator(label);
            this.linkDefLabels.put(label, (NameAccessAccumulator<WikitextNameAccess>)shared);
        }
        RefLabelAccess.LinkDef access = new RefLabelAccess.LinkDef((NameAccessAccumulator<WikitextNameAccess>)shared, node, labelNode);
        node.addAttachment(access);
        return access;
    }

    @Override
    public void visit(SourceComponent node) throws InvocationTargetException {
        this.currentElement.startOffset = node.getStartOffset();
        node.acceptInWikitextChildren(this);
        if (this.titleElement != null) {
            this.finishTitleText();
        }
        while ((this.currentElement.getElementType() & 0xF00) != 512) {
            this.exitContainer(node.getEndOffset(), true);
        }
        this.exitContainer(node.getEndOffset(), true);
    }

    @Override
    public void visit(Block node) throws InvocationTargetException {
        if (node.getLabel() != null) {
            RefLabelAccess access = this.addLinkAnchorAccess(node);
            access.flags |= 2;
        }
        node.acceptInWikitextChildren(this);
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visit(Heading node) throws InvocationTargetException {
        block5: {
            if (node.getLabel() != null) {
                access = this.addLinkAnchorAccess(node);
                access.flags |= 2;
            }
            if ((this.currentElement.getElementType() & 4080) != 1056 && (this.currentElement.getElementType() & 3840) != 512 || (level = node.getLevel()) > 5) break block5;
            if (this.titleElement == null) ** GOTO lbl9
            this.finishTitleText();
            break block5;
lbl-1000:
            // 1 sources

            {
                this.exitContainer(node.getStartOffset(), false);
lbl9:
                // 2 sources

                ** while ((this.currentElement.getElementType() & 4080) == 1056 && (this.currentElement.getElementType() & 15) >= level)
            }
lbl10:
            // 1 sources

            this.initElement(new WikitextSourceElement.StructContainer(1056 | level, this.currentElement, node));
            node.addAttachment(this.currentElement);
            this.minSectionLevel = Math.min(this.minSectionLevel, level);
            this.maxSectionLevel = Math.max(this.maxSectionLevel, level);
            count = node.getChildCount();
            if (count > 0) {
                this.titleElement = this.currentElement;
                this.titleDoBuild = true;
                nameStartOffset = node.getChild(0).getStartOffset();
                nameEndOffset = this.readLinebreakBackward(node.getChild(count - 1).getEndOffset(), nameStartOffset);
                this.titleElement.nameRegion = new BasicTextRegion(nameStartOffset, nameEndOffset);
                node.acceptInWikitextChildren(this);
                if (this.titleElement != null) {
                    this.finishTitleText();
                }
            } else {
                this.currentElement.name = WikitextElementName.create(17, "");
                this.currentElement.nameRegion = new BasicTextRegion(node.getStartOffset());
            }
            this.currentElement.length = Math.max(this.currentElement.length, node.getLength());
            return;
        }
        node.acceptInWikitextChildren(this);
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    @Override
    public void visit(Span node) throws InvocationTargetException {
        if (node.getLabel() != null) {
            RefLabelAccess access = this.addLinkAnchorAccess(node);
            access.flags |= 2;
        }
        node.acceptInWikitextChildren(this);
    }

    @Override
    public void visit(Text node) throws InvocationTargetException {
        String text;
        if (this.titleDoBuild && (text = node.getText()) != null) {
            this.titleBuilder.append(text);
            if (this.titleBuilder.length() >= 100) {
                this.finishTitleText();
            }
        }
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }

    @Override
    public void visit(Link node) throws InvocationTargetException {
        switch (node.getLinkType()) {
            case 1: {
                RefLabelAccess access = this.addLinkDefAccess(node, node.getReferenceLabel());
                access.flags |= 2;
                break;
            }
            case 2: {
                RefLabelAccess access = this.addLinkDefAccess(node, node.getReferenceLabel());
                break;
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(Image node) throws InvocationTargetException {
        switch (node.getImageType()) {
            case 2: {
                RefLabelAccess access = this.addLinkDefAccess(node, node.getReferenceLabel());
                break;
            }
        }
        super.visit(node);
    }

    @Override
    public void visit(Embedded node) throws InvocationTargetException {
        if (node.getForeignNode() == null) {
            super.visit(node);
            return;
        }
        if ((node.getEmbedDescr() & 3) == 2) {
            if (this.titleDoBuild) {
                this.titleBuilder.append(this.input, node.getStartOffset(), node.getEndOffset());
                if (this.titleBuilder.length() >= 100) {
                    this.finishTitleText();
                }
            }
            this.embeddedItems.add(new EmbeddingReconcileItem(node, null));
        } else {
            if (this.titleElement != null) {
                this.finishTitleText();
            }
            if (this.currentElement.children.isEmpty()) {
                this.currentElement.children = new ArrayList<WikitextSourceElement>();
            }
            WikitextSourceElement.EmbeddedRef element = new WikitextSourceElement.EmbeddedRef(node.getText(), this.currentElement, node);
            element.startOffset = node.getStartOffset();
            element.length = node.getLength();
            element.name = WikitextElementName.create(0, "");
            this.currentElement.children.add(element);
            this.embeddedItems.add(new EmbeddingReconcileItem(node, element));
        }
        this.currentElement.length = node.getEndOffset() - this.currentElement.getStartOffset();
    }
}

