/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.collections.IdentitySet;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class ActionUtil<TElement> {
    public static final String CONTENT_TYPE_PAR_NAME = "contentTypeId";
    public static final String LAUNCH_FLAGS_PAR_NAME = "launchFlags";
    public static final byte ACTIVE_EDITOR_MODE = 1;
    public static final byte ACTIVE_MENU_SELECTION_MODE = 2;
    private byte mode;

    static void activateActiveEditor(IWorkbenchWindow window) {
        IWorkbenchPage page = window.getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        if (activeEditor != null && activeEditor != page.getActivePart()) {
            page.activate((IWorkbenchPart)activeEditor);
        }
    }

    static IWorkbenchWindow getWindow(@Nullable IServiceLocator serviceLocator) {
        IWorkbenchWindow window = null;
        if (serviceLocator != null) {
            window = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
        }
        if (window == null) {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        return window;
    }

    public ActionUtil(byte initialMode) {
        this.mode = initialMode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public byte getMode() {
        return this.mode;
    }

    public @Nullable TElement getLaunchElement(@Nullable IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        switch (this.getMode()) {
            case 1: {
                return this.getLaunchElement(this.getActiveEditor(window));
            }
            case 2: {
                return this.getLaunchElement(this.getActiveSelection(window));
            }
        }
        return null;
    }

    public abstract @Nullable TElement getLaunchElement(@Nullable IEditorPart var1);

    public abstract @Nullable TElement getLaunchElement(@Nullable ISelection var1);

    public abstract @Nullable LaunchConfigManager<TElement> getManager(IWorkbenchWindow var1, TElement var2);

    protected @Nullable IEditorPart getActiveEditor(IWorkbenchWindow window) {
        return window.getActivePage().getActiveEditor();
    }

    protected @Nullable ISelection getActiveSelection(IWorkbenchWindow window) {
        Object selection;
        @Nullable IEclipseContext eContext = (IEclipseContext)window.getService(IEclipseContext.class);
        if (eContext != null && (selection = eContext.get("activeMenuSelection")) instanceof ISelection) {
            return (ISelection)selection;
        }
        return null;
    }

    protected @Nullable IResource getSingleResource(@Nullable IEditorInput editorInput) {
        if (editorInput == null) {
            return null;
        }
        IResource resource = (IResource)Adapters.adapt((Object)editorInput, IResource.class);
        if (resource != null) {
            return resource;
        }
        return (IResource)Adapters.adapt((Object)editorInput, IFile.class);
    }

    protected @Nullable IResource getSingleResource(@Nullable IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            Object element = selection.getFirstElement();
            if (element instanceof IResource) {
                return (IResource)element;
            }
            if (element instanceof IAdaptable) {
                return (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
        }
        return null;
    }

    public void launchActive(final IWorkbenchWindow window, final LaunchConfigManager<TElement> manager, TElement element, ImIdentitySet<String> launchFlags) {
        ILaunchConfiguration config = manager.getActiveConfig();
        if (config != null) {
            manager.launch(config, element, (IdentitySet<String>)launchFlags);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (ActionUtil.this.getMode() == 1) {
                        ActionUtil.activateActiveEditor(window);
                    }
                    manager.openConfigurationDialog(window.getShell(), null);
                }
            };
            UIAccess.getDisplay().asyncExec(runnable);
        }
    }
}

