/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;

public class StatusInfo
extends Status {
    public static void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(null, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.isEmpty()) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    public static void applyToStatusLine(TitleAreaDialog page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                if (message.equals("OK") || message.equals(OK_STATUS.getMessage())) {
                    page.setMessage(null, 0);
                } else {
                    page.setMessage(message, 0);
                }
                page.setMessage(!status.getMessage().equals("OK") ? status.getMessage() : null, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    public StatusInfo() {
        this(0, "");
    }

    public StatusInfo(int severity, String message) {
        super(severity, "no supported", 0, message, null);
    }

    public void setOK() {
        this.setSeverity(0);
        this.setMessage("");
    }

    public void setWarning(String message) {
        this.setSeverity(2);
        this.setMessage(message);
    }

    public void setError(String message) {
        this.setSeverity(4);
        this.setMessage(message);
    }
}

