/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;

public class BookmarkCollection {
    private static final Map<String, BookmarkCollection> gCollections = new HashMap<String, BookmarkCollection>();
    private static final char SEPARATOR = '\u001f';
    private static final Pattern SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("\u001f"));
    private final String qualifier;
    private final Preference.StringArrayPref pref;
    private final List<BrowserBookmark> bookmarks = new ArrayList<BrowserBookmark>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BookmarkCollection getCollection(String qualifier) {
        Map<String, BookmarkCollection> map = gCollections;
        synchronized (map) {
            BookmarkCollection collection = gCollections.get(qualifier);
            if (collection == null) {
                collection = new BookmarkCollection(qualifier);
                gCollections.put(qualifier, collection);
            }
            return collection;
        }
    }

    private BookmarkCollection(String qualifier) {
        this.qualifier = qualifier;
        this.pref = new Preference.StringArrayPref(qualifier, "bookmarks", '\u001e');
        this.load();
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public List<BrowserBookmark> getBookmarks() {
        return this.bookmarks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        List<BrowserBookmark> list = this.bookmarks;
        synchronized (list) {
            String[] strings;
            String[] stringArray = strings = (String[])PreferenceUtils.getInstancePrefs().getPreferenceValue((Preference)this.pref);
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                BrowserBookmark bookmark = null;
                String[] split = SEPARATOR_PATTERN.split(s);
                if (split.length == 2) {
                    bookmark = new BrowserBookmark(split[0], split[1]);
                }
                if (bookmark != null) {
                    this.bookmarks.add(bookmark);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        List<BrowserBookmark> list = this.bookmarks;
        synchronized (list) {
            String[] strings = new String[this.bookmarks.size()];
            int i = 0;
            while (i < this.bookmarks.size()) {
                BrowserBookmark bookmark = this.bookmarks.get(i);
                strings[i] = String.valueOf(bookmark.getLabel()) + '\u001f' + bookmark.getUrl();
                ++i;
            }
            PreferenceUtils.setPrefValue((IScopeContext)InstanceScope.INSTANCE, (Preference)this.pref, (Object)strings, (int)2);
        }
    }
}

