/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.freeze;

import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeEvent;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.UnfreezeEvent;
import org.eclipse.statet.ecommons.waltable.viewport.ViewportLayer;

public class FreezeHelper {
    public static void freeze(FreezeLayer freezeLayer, ViewportLayer viewportLayer, PositionCoordinate topLeftPosition, PositionCoordinate bottomRightPosition) {
        if (freezeLayer == null || viewportLayer == null) {
            throw new IllegalArgumentException("freezeLayer and viewportLayer can not be null!");
        }
        if (topLeftPosition != null && bottomRightPosition != null) {
            freezeLayer.setFreeze(topLeftPosition.columnPosition, topLeftPosition.rowPosition, bottomRightPosition.columnPosition, bottomRightPosition.rowPosition);
            viewportLayer.getDim(Orientation.HORIZONTAL).setMinimumOriginPosition(bottomRightPosition.columnPosition + 1L);
            viewportLayer.getDim(Orientation.VERTICAL).setMinimumOriginPosition(bottomRightPosition.rowPosition + 1L);
            viewportLayer.fireLayerEvent(new FreezeEvent(viewportLayer));
        }
    }

    public static void unfreeze(FreezeLayer freezeLayer, ViewportLayer viewportLayer) {
        if (freezeLayer == null || viewportLayer == null) {
            throw new IllegalArgumentException("freezeLayer and viewportLayer can not be null!");
        }
        FreezeHelper.resetViewport(freezeLayer, viewportLayer);
        viewportLayer.fireLayerEvent(new UnfreezeEvent(viewportLayer));
    }

    public static void resetViewport(FreezeLayer freezeLayer, ViewportLayer viewportLayer) {
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            if (freezeLayer.isFrozen()) {
                FreezeLayer.Dim freezeDim = freezeLayer.get(orientation);
                long position = freezeDim.getStartPosition();
                freezeDim.setFreeze(0L, 0L);
                viewportLayer.getDim(orientation).reset(position);
            }
            ++n2;
        }
    }
}

