/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class BeveledBorderDecorator
extends CellPainterWrapper {
    private boolean uplift = true;

    public BeveledBorderDecorator(ICellPainter interiorPainter) {
        super(interiorPainter);
    }

    public BeveledBorderDecorator(ICellPainter interiorPainter, boolean uplift) {
        super(interiorPainter);
        this.uplift = uplift;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredWidth(cell, gc, configRegistry) + 4L;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return super.getPreferredHeight(cell, gc, configRegistry) + 4L;
    }

    @Override
    public LRectangle getWrappedPainterBounds(ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        return new LRectangle(bounds.x + 2L, bounds.y + 2L, bounds.width - 4L, bounds.height - 4L);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        LRectangle interiorBounds = this.getWrappedPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        Color originalForeground = gc.getForeground();
        Rectangle rect = GraphicsUtils.safe(adjustedCellBounds);
        gc.setForeground(this.uplift ? GUIHelper.COLOR_WIDGET_LIGHT_SHADOW : GUIHelper.COLOR_WIDGET_DARK_SHADOW);
        gc.drawLine(rect.x, rect.y, rect.x + rect.width - 1, rect.y);
        gc.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        gc.setForeground(this.uplift ? GUIHelper.COLOR_WIDGET_HIGHLIGHT_SHADOW : GUIHelper.COLOR_WIDGET_NORMAL_SHADOW);
        gc.drawLine(rect.x + 1, rect.y + 1, rect.x + rect.width - 1, rect.y + 1);
        gc.drawLine(rect.x + 1, rect.y + 1, rect.x + 1, rect.y + rect.height - 1);
        gc.setForeground(this.uplift ? GUIHelper.COLOR_WIDGET_DARK_SHADOW : GUIHelper.COLOR_WIDGET_LIGHT_SHADOW);
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width - 1, rect.y + rect.height - 1);
        gc.drawLine(rect.x + rect.width - 1, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
        gc.setForeground(this.uplift ? GUIHelper.COLOR_WIDGET_NORMAL_SHADOW : GUIHelper.COLOR_WIDGET_HIGHLIGHT_SHADOW);
        gc.drawLine(rect.x, rect.y + rect.height - 2, rect.x + rect.width - 1, rect.y + rect.height - 2);
        gc.drawLine(rect.x + rect.width - 2, rect.y, rect.x + rect.width - 2, rect.y + rect.height - 2);
        gc.setForeground(originalForeground);
    }
}

