/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.layer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.ILayerDim;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellLayerPainter
implements ILayerPainter {
    private ILayer natLayer;
    private Map<Long, Long> horizontalPositionToPixelMap;
    private Map<Long, Long> verticalPositionToPixelMap;

    protected static final long getEndPosition(ILayerDim dim, int pixel) {
        long positionByPixel = dim.getPositionByPixel(pixel);
        return positionByPixel > 0L ? Math.min(dim.getPositionCount(), positionByPixel) : dim.getPositionCount();
    }

    private static Map<Long, Long> calculateDimensionInfo(ILayerDim dim, long startPosition, long endPosition) {
        HashMap<Long, Long> positionToPixelMap = new HashMap<Long, Long>();
        long start2 = startPosition > 0L ? dim.getPositionStart(startPosition - 1L) + (long)dim.getPositionSize(startPosition - 1L) : Long.MIN_VALUE;
        long position = startPosition;
        while (position < endPosition) {
            long start1 = dim.getPositionStart(position);
            positionToPixelMap.put(position, Math.max(start1, start2));
            start2 = start1 + (long)dim.getPositionSize(position);
            ++position;
        }
        if (endPosition < dim.getPositionCount()) {
            long start1 = dim.getPositionStart(endPosition);
            positionToPixelMap.put(endPosition, Math.max(start1, start2));
        }
        return positionToPixelMap;
    }

    private static long getPositionStart(ILayerDim dim, long position, Map<Long, Long> positionToPixelMap) {
        if (position < dim.getPositionCount()) {
            Long start = positionToPixelMap.get(position);
            if (start == null) {
                long start2;
                start = dim.getPositionStart(position);
                if (position > 0L && (start2 = dim.getPositionStart(position - 1L) + dim.getPositionStart(position - 1L)) > start) {
                    start = start2;
                }
                positionToPixelMap.put(position, start);
            }
            return start;
        }
        return dim.getSize();
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        if (pixelRectangle.isEmpty()) {
            return;
        }
        this.natLayer = natLayer;
        LRectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        this.calculateDimensionInfo(positionRectangle);
        HashSet<ILayerCell> spannedCells = new HashSet<ILayerCell>();
        long columnPosition = positionRectangle.x;
        while (columnPosition < positionRectangle.x + positionRectangle.width) {
            long rowPosition = positionRectangle.y;
            while (rowPosition < positionRectangle.y + positionRectangle.height) {
                ILayerCell cell = natLayer.getCellByPosition(columnPosition, rowPosition);
                if (cell != null) {
                    if (cell.isSpannedCell()) {
                        spannedCells.add(cell);
                    } else {
                        this.paintCell(cell, gc, configRegistry);
                    }
                }
                ++rowPosition;
            }
            ++columnPosition;
        }
        for (ILayerCell cell : spannedCells) {
            this.paintCell(cell, gc, configRegistry);
        }
    }

    private void calculateDimensionInfo(LRectangle positionRectangle) {
        this.horizontalPositionToPixelMap = CellLayerPainter.calculateDimensionInfo(this.natLayer.getDim(Orientation.HORIZONTAL), positionRectangle.x, positionRectangle.x + positionRectangle.width);
        this.verticalPositionToPixelMap = CellLayerPainter.calculateDimensionInfo(this.natLayer.getDim(Orientation.VERTICAL), positionRectangle.y, positionRectangle.y + positionRectangle.height);
    }

    @Override
    public LRectangle adjustCellBounds(long columnPosition, long rowPosition, LRectangle cellBounds) {
        return cellBounds;
    }

    protected LRectangle getPositionRectangleFromPixelRectangle(ILayer natLayer, Rectangle pixelRectangle) {
        long columnPositionOffset = natLayer.getColumnPositionByX(pixelRectangle.x);
        long rowPositionOffset = natLayer.getRowPositionByY(pixelRectangle.y);
        long numColumns = natLayer.getColumnPositionByX(Math.min(natLayer.getWidth(), (long)(pixelRectangle.x + pixelRectangle.width)) - 1L) - columnPositionOffset + 1L;
        long numRows = natLayer.getRowPositionByY(Math.min(natLayer.getHeight(), (long)(pixelRectangle.y + pixelRectangle.height)) - 1L) - rowPositionOffset + 1L;
        if (columnPositionOffset < 0L || rowPositionOffset < 0L || numColumns < 0L || numRows < 0L) {
            throw new RuntimeException();
        }
        return new LRectangle(columnPositionOffset, rowPositionOffset, numColumns, numRows);
    }

    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        ILayer layer = cell.getLayer();
        long columnPosition = cell.getColumnPosition();
        long rowPosition = cell.getRowPosition();
        ICellPainter cellPainter = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_PAINTER, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
        LRectangle adjustedCellBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
        if (cellPainter != null) {
            Rectangle originalClipping = gc.getClipping();
            long startX = this.getColumnPositionStart(columnPosition);
            long startY = this.getRowPositionStart(rowPosition);
            long endX = this.getColumnPositionStart(cell.getOriginColumnPosition() + cell.getColumnSpan());
            long endY = this.getRowPositionStart(cell.getOriginRowPosition() + cell.getRowSpan());
            LRectangle clipBounds = new LRectangle(startX, startY, endX - startX, endY - startY);
            LRectangle adjustedClipBounds = clipBounds.intersection(adjustedCellBounds);
            gc.setClipping(GraphicsUtils.safe(adjustedClipBounds));
            cellPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
            gc.setClipping(originalClipping);
        }
    }

    private long getColumnPositionStart(long columnPosition) {
        return CellLayerPainter.getPositionStart(this.natLayer.getDim(Orientation.HORIZONTAL), columnPosition, this.horizontalPositionToPixelMap);
    }

    private long getRowPositionStart(long rowPosition) {
        return CellLayerPainter.getPositionStart(this.natLayer.getDim(Orientation.VERTICAL), rowPosition, this.verticalPositionToPixelMap);
    }
}

