/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.text.core.input;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.string.CharArrayString;
import org.eclipse.statet.jcommons.string.StringFactory;

@NonNullByDefault
public abstract class TextParserInput {
    public static final int EOF = -1;
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected static final char[] NO_INPUT = new char[0];
    private final CharArrayString tmpCharString = new CharArrayString();
    private int startIndex;
    private int stopIndex;
    private final int defaultBufferLength;
    private char[] buffer;
    private int currentIdx;
    private int endIdx;
    private int currentIndex;

    protected TextParserInput(int defaultBufferLength) {
        this.defaultBufferLength = defaultBufferLength;
        this.buffer = NO_INPUT;
        this.stopIndex = Integer.MIN_VALUE;
        this.currentIndex = Integer.MIN_VALUE;
    }

    protected void reset() {
        this.startIndex = 0;
        this.stopIndex = Integer.MIN_VALUE;
        this.currentIndex = Integer.MIN_VALUE;
        this.currentIdx = 0;
        this.endIdx = 0;
    }

    public TextParserInput init() {
        this.init(0, Integer.MIN_VALUE);
        return this;
    }

    public TextParserInput init(int startIndex, int stopIndex) {
        int length = this.getSourceLength();
        if (length > 0) {
            int sourceStartIndex = this.getSourceStartIndex();
            int sourceStopIndex = sourceStartIndex + length;
            if (stopIndex > sourceStopIndex) {
                throw new IndexOutOfBoundsException("stopIndex= " + stopIndex);
            }
            if (stopIndex == Integer.MIN_VALUE) {
                stopIndex = sourceStopIndex;
            }
            if (startIndex < sourceStartIndex | startIndex > sourceStopIndex) {
                throw new IndexOutOfBoundsException("startIndex= " + startIndex);
            }
            if (startIndex > stopIndex) {
                throw new IllegalArgumentException("startIndex > stopIndex: startIndex= " + startIndex + ", stopIndex= " + stopIndex);
            }
        }
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.currentIndex = startIndex;
        this.currentIdx = 0;
        this.endIdx = 0;
        this.updateBuffer(0);
        return this;
    }

    protected int getSourceStartIndex() {
        return 0;
    }

    protected int getSourceLength() {
        return -1;
    }

    protected @Nullable String getSourceString() {
        return null;
    }

    protected int getSourceStringIndex() {
        return 0;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getStopIndex() {
        return this.stopIndex;
    }

    public final int getIndex() {
        return this.currentIndex;
    }

    public int getIndex(int offset) {
        return this.currentIndex + offset;
    }

    public int getLengthInSource(int offset) {
        return offset;
    }

    public final int get(int offset) {
        int idx = this.currentIdx + offset;
        if (idx >= this.endIdx) {
            if (this.updateBuffer(offset + 1)) {
                idx = this.currentIdx + offset;
            } else {
                return -1;
            }
        }
        return this.buffer[idx];
    }

    public final boolean matches(int offset, char c1) {
        int idx = this.currentIdx + offset;
        if (idx >= this.endIdx) {
            if (this.updateBuffer(offset + 1)) {
                idx = this.currentIdx + offset;
            } else {
                return false;
            }
        }
        return this.buffer[idx] == c1;
    }

    public final boolean matches(int offset, char c1, char c2) {
        int idx = this.currentIdx + offset;
        if (idx + 1 >= this.endIdx) {
            if (this.updateBuffer(offset + 2)) {
                idx = this.currentIdx + offset;
            } else {
                return false;
            }
        }
        return this.buffer[idx] == c1 && this.buffer[++idx] == c2;
    }

    public final boolean matches(int offset, char c1, char c2, char c3) {
        int idx = this.currentIdx + offset;
        if (idx + 2 >= this.endIdx) {
            if (this.updateBuffer(offset + 3)) {
                idx = this.currentIdx + offset;
            } else {
                return false;
            }
        }
        return this.buffer[idx] == c1 && this.buffer[++idx] == c2 && this.buffer[++idx] == c3;
    }

    public final boolean matches(int offset, char[] sequence) {
        int idx = this.currentIdx + offset;
        int l = sequence.length;
        if (idx + l > this.endIdx) {
            if (this.updateBuffer(offset + l)) {
                idx = this.currentIdx + offset;
            } else {
                return false;
            }
        }
        offset = 0;
        while (offset < l) {
            if (this.buffer[idx++] != sequence[offset]) {
                return false;
            }
            ++offset;
        }
        return true;
    }

    public void consume(int offset) {
        this.setConsume(offset, this.currentIndex + offset);
    }

    protected final void setConsume(int offset, int index) {
        this.currentIdx += offset;
        this.currentIndex = index;
    }

    protected boolean updateBuffer(int requiredLength) {
        int index = this.currentIndex;
        if (index + requiredLength > this.stopIndex) {
            return false;
        }
        char[] buffer = this.buffer;
        int recommendLength = this.defaultBufferLength;
        if (requiredLength > recommendLength) {
            recommendLength = (requiredLength + 1040) / 1024 * 1024;
        }
        if (buffer.length < recommendLength) {
            buffer = new char[recommendLength];
        }
        this.doUpdateBuffer(index, buffer, requiredLength, recommendLength);
        return this.currentIdx + requiredLength <= this.endIdx;
    }

    protected void doUpdateBuffer(int index, char[] buffer, int requiredLength, int recommendLength) {
        this.setBuffer(NO_INPUT, 0, 0);
    }

    protected final int copyBuffer0(char[] buffer) {
        int l = this.endIdx - this.currentIdx;
        if (l > 0) {
            System.arraycopy(this.buffer, this.currentIdx, buffer, 0, l);
        }
        return l;
    }

    protected final char[] getBuffer() {
        return this.buffer;
    }

    protected final void setBuffer(char[] buffer, int currentIdx, int length) {
        this.buffer = buffer;
        this.currentIdx = currentIdx;
        this.endIdx = this.checkEndIdx(currentIdx + length);
        this.tmpCharString.clear();
    }

    private int checkEndIdx(int idx) {
        int stopIdx;
        if (this.stopIndex >= 0 && (stopIdx = this.currentIdx - this.currentIndex + this.stopIndex) < idx) {
            idx = stopIdx;
        }
        return idx > 0 ? idx : 0;
    }

    protected final int getIndexIdx() {
        return this.currentIdx;
    }

    protected final int getEndIdx() {
        return this.endIdx;
    }

    protected final CharArrayString getTmpString(int offset, int length) {
        this.tmpCharString.set(this.buffer, this.currentIdx + offset, length);
        return this.tmpCharString;
    }

    public final String getString(int offset, int length) {
        return new String(this.buffer, this.currentIdx + offset, length);
    }

    public final @Nullable String getString(int offset, int length, StringFactory factory) {
        this.tmpCharString.set(this.buffer, this.currentIdx + offset, length);
        return factory.get(this.tmpCharString);
    }

    public final void appendTo(int offset, int length, StringBuilder dst) {
        switch (length) {
            case 0: {
                return;
            }
            case 1: {
                dst.append(this.buffer[this.currentIdx + offset]);
                return;
            }
        }
        dst.append(this.buffer, this.currentIdx + offset, length);
    }

    public final void insertInto(int offset, int length, StringBuilder dst, int dstOffset) {
        switch (length) {
            case 0: {
                return;
            }
            case 1: {
                dst.insert(dstOffset, this.buffer[this.currentIdx + offset]);
                return;
            }
        }
        dst.insert(dstOffset, this.buffer, this.currentIdx + offset, length);
    }

    protected final void checkOffset(int offset) {
        if (this.currentIdx + offset > this.endIdx) {
            throw new IndexOutOfBoundsException("offset= " + offset);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        String s = this.getSourceString();
        if (s != null) {
            int index = this.getSourceStringIndex();
            sb.append("\n~~~ [").append(index).append(", ").append(index + s.length()).append("] ~~~");
            sb.append(this.getSourceStringIndex());
            sb.append("\n~~~\n");
        }
        return super.toString();
    }
}

