/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault(value={NullDefaultLocation.PARAMETER, NullDefaultLocation.RETURN_TYPE, NullDefaultLocation.FIELD, NullDefaultLocation.TYPE_BOUND, NullDefaultLocation.TYPE_ARGUMENT})
public final class CopyOnWriteListSet<E>
extends AbstractSet<E>
implements Set<E> {
    private volatile ImList<E> list;

    private static int indexOf(Object[] array, @Nullable Object e) {
        if (e == null) {
            int i = 0;
            while (i < array.length) {
                if (array[i] == null) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (e.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CopyOnWriteListSet() {
        this.list = ImCollections.newList();
    }

    public CopyOnWriteListSet(Set<E> initialSet) {
        this.list = ImCollections.toIdentityList(initialSet);
    }

    @Override
    public synchronized boolean add(E element) {
        if (!this.list.contains(element)) {
            this.list = ImCollections.addElement(this.list, element);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(@Nullable Object element) {
        ImList<E> l = ImCollections.removeElement(this.list, element);
        if (l != this.list) {
            this.list = l;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        ImList<E> l = this.list;
        Object[] toAdd = c.toArray();
        int end = toAdd.length;
        int i = 0;
        while (i < end) {
            if (l.contains(toAdd[i]) || CopyOnWriteListSet.indexOf(toAdd, toAdd[i]) < i) {
                System.arraycopy(toAdd, i + 1, toAdd, i, end - i - 1);
                --end;
                continue;
            }
            ++i;
        }
        if (end > 0) {
            this.list = ImCollections.concatList(l, ImCollections.newList(toAdd, 0, end));
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        Object[] array = this.list.toArray();
        Object[] toRetain = c.toArray();
        int end = array.length;
        int i = 0;
        while (i < end) {
            if (CopyOnWriteListSet.indexOf(toRetain, array[i]) >= 0) {
                ++i;
                continue;
            }
            System.arraycopy(array, i + 1, array, i, end - i - 1);
            --end;
        }
        if (end < array.length) {
            this.list = ImCollections.newList(array, 0, end);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        Object[] array = this.list.toArray();
        Object[] toRemove = c.toArray();
        int end = array.length;
        int i = 0;
        while (i < end) {
            if (CopyOnWriteListSet.indexOf(toRemove, array[i]) >= 0) {
                ++i;
                continue;
            }
            System.arraycopy(array, i + 1, array, i, end - i - 1);
            --end;
        }
        if (end < array.length) {
            this.list = ImCollections.newList(array, 0, end);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        if (!this.list.isEmpty()) {
            this.list = ImCollections.newList();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(@Nullable Object o) {
        return this.list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.list.spliterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    public ImList<E> toList() {
        return this.list;
    }

    public synchronized ImList<E> clearToList() {
        ImList<E> list = this.list;
        if (!list.isEmpty()) {
            this.list = ImCollections.newList();
        }
        return list;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Set) {
            Set other = (Set)obj;
            ImList<E> l = this.list;
            return l.size() == other.size() && l.containsAll(other);
        }
        return false;
    }
}

