/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime.bundle;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.runtime.ClassLoaderUtils;
import org.eclipse.statet.jcommons.runtime.CommonsRuntime;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public abstract class BundleEntryProvider {
    private final ImList<Path> baseDirectories;
    private final List<Closeable> closeables;
    private static final String FILE_PROTOCOL_REGEX = "\\Qfile:/\\E";
    private static final String JAR_FILE_PROTOCOL_REGEX = "\\Qjar:file:/\\E";
    private static final String BUNDLE_ID_REGEX = "[a-z]+(?:\\.?[a-z]+)*";
    private static final String VER_1_REGEX = "\\_\\d+\\.\\d+[^!/]+";
    private static final String VER_2_REGEX = "\\-\\d+\\.\\d+[^!/]+";
    private static final String JAR_REGEX = "(?<![-._]sources?)\\Q.jar\\E";
    private static final String AUTODETECT_REGEX = "(?:(\\Qfile:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*)\\Q/target/classes/\\E|(\\Qjar:file:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?(?<![-._]sources?)\\Q.jar\\E)\\Q!/\\E)";
    private static final Pattern AUTODETECT_PATTERN = Pattern.compile("(?:(\\Qfile:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*)\\Q/target/classes/\\E|(\\Qjar:file:/\\E.*)/([a-z]+(?:\\.?[a-z]+)*(?:(\\_\\d+\\.\\d+[^!/]+)|(\\-\\d+\\.\\d+[^!/]+))?(?<![-._]sources?)\\Q.jar\\E)\\Q!/\\E)");
    private static final int AUTODETECT_FILE_PROTOCOL_BASE_NUM = 1;
    private static final int AUTODETECT_FILE_PROTOCOL_NAME_NUM = 2;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_BASE_NUM = 3;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_NAME_NUM = 4;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_VER_1_NUM = 5;
    private static final int AUTODETECT_JAR_FILE_PROTOCOL_VER_2_NUM = 6;
    private static final Pattern JAR_VER_0_PATTERN = Pattern.compile("(.+?)(?<![-._]sources?)\\Q.jar\\E");
    private static final Pattern JAR_VER_1_PATTERN = Pattern.compile("(.+?)\\_\\d+\\.\\d+[^!/]+(?<![-._]sources?)\\Q.jar\\E");
    private static final Pattern JAR_VER_2_PATTERN = Pattern.compile("(.+?)\\-\\d+\\.\\d+[^!/]+(?<![-._]sources?)\\Q.jar\\E");

    protected BundleEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
        this.baseDirectories = baseDirectories;
        this.closeables = closeables;
    }

    public void dispose() {
        BundleEntryProvider.close(this.closeables);
    }

    protected ImList<Path> getBaseDirectories() {
        return this.baseDirectories;
    }

    public void getEntries(List<BundleEntry> entries) {
        for (Path baseDirectory : this.baseDirectories) {
            try {
                this.getEntries(baseDirectory, entries);
            }
            catch (Exception e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("An error occurred when looking for path entries in '%1$s'.", baseDirectory), e));
            }
        }
    }

    protected void getEntries(Path baseDirectory, List<BundleEntry> entries) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> children = Files.newDirectoryStream(baseDirectory);){
            for (Path child : children) {
                BundleEntry entry = this.createEntry(child);
                if (entry == null) continue;
                entries.add(entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected @Nullable BundleEntry createEntry(Path candidate) {
        return null;
    }

    public int hashCode() {
        return this.getClass().hashCode() + this.baseDirectories.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            BundleEntryProvider other = (BundleEntryProvider)obj;
            return this.baseDirectories.equals(other.baseDirectories);
        }
        return false;
    }

    public static BundleEntryProvider detectEntryProvider(Class<?> refClass, @Nullable List<Path> expliciteBaseDirectories) throws StatusException {
        String refUrl = null;
        try {
            refUrl = ClassLoaderUtils.getClassLocationUrlString(refClass);
            return BundleEntryProvider.detectEntryProvider(refUrl, expliciteBaseDirectories);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to autodetect bundle location\n\tclass= %1$s\n\turl= %2$s", refClass != null ? refClass.getName() : "<NA>", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e));
        }
    }

    public static BundleEntry detectEntry(Class<?> refClass) throws StatusException {
        String refUrl = null;
        try {
            refUrl = ClassLoaderUtils.getClassLocationUrlString(refClass);
            return BundleEntryProvider.detectEntry(refUrl);
        }
        catch (Exception e) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", String.format("Failed to autodetect bundle location\n\tclass= %1$s\n\turl= %2$s", refClass != null ? refClass.getName() : "<NA>", refUrl != null ? String.valueOf('\'') + refUrl + '\'' : "<NA>"), e));
        }
    }

    static BundleEntryProvider detectEntryProvider(String refUrl, @Nullable List<Path> expliciteBaseDirectories) throws Exception {
        ImList<Closeable> closeables = ImCollections.emptyList();
        try {
            Matcher matcher = AUTODETECT_PATTERN.matcher(refUrl);
            if (matcher.matches()) {
                BundleEntryProvider provider;
                Path detectedBaseDirectory;
                URI detectedBaseUri;
                String s;
                int detectedType;
                if (matcher.start(1) != -1) {
                    detectedType = 1;
                    s = ObjectUtils.nonNullAssert(matcher.group(1));
                    detectedBaseUri = new URI(s);
                } else if (matcher.start(3) != -1) {
                    detectedType = 2;
                    s = ObjectUtils.nonNullAssert(matcher.group(3));
                    detectedBaseUri = s.indexOf("!/") == -1 ? new URI(s.substring(4)) : new URI(s);
                } else {
                    throw new IllegalStateException();
                }
                while (true) {
                    try {
                        detectedBaseDirectory = Paths.get(detectedBaseUri);
                    }
                    catch (FileSystemNotFoundException e) {
                        HashMap<String, String> fsEnv = new HashMap<String, String>();
                        fsEnv.put("create", "true");
                        try {
                            FileSystem fileSystem = FileSystems.newFileSystem(detectedBaseUri, fsEnv);
                        }
                        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {}
                        continue;
                    }
                    break;
                }
                detectedBaseDirectory = detectedBaseDirectory.normalize();
                ArrayList<Path> uniqueList = new ArrayList<Path>();
                if (expliciteBaseDirectories != null && !expliciteBaseDirectories.isEmpty()) {
                    for (Path baseDirectory : expliciteBaseDirectories) {
                        if (uniqueList.contains(baseDirectory = baseDirectory.normalize())) continue;
                        uniqueList.add(baseDirectory);
                    }
                }
                if (!uniqueList.contains(detectedBaseDirectory)) {
                    uniqueList.add(detectedBaseDirectory);
                }
                ImList<Path> baseDirectories = ImCollections.toList(uniqueList);
                if (detectedType == 1) {
                    provider = new DevBinPathEntryProvider(baseDirectories, closeables);
                } else {
                    Pattern fileNamePattern = matcher.start(5) != -1 ? JAR_VER_1_PATTERN : (matcher.start(6) != -1 ? JAR_VER_2_PATTERN : JAR_VER_0_PATTERN);
                    provider = new JarFilePathEntryProvider(baseDirectories, fileNamePattern, closeables);
                }
                closeables = null;
                DevBinPathEntryProvider devBinPathEntryProvider = provider;
                return devBinPathEntryProvider;
            }
            throw new UnsupportedOperationException("url= " + refUrl);
        }
        finally {
            if (closeables != null) {
                BundleEntryProvider.close(closeables);
            }
        }
    }

    static BundleEntry detectEntry(String refUrl) throws Exception {
        ImList<Closeable> closeables = ImCollections.emptyList();
        try {
            Matcher matcher = AUTODETECT_PATTERN.matcher(refUrl);
            if (matcher.matches()) {
                BundleEntryProvider provider;
                Path detectedBaseDirectory;
                String fileName;
                URI detectedBaseUri;
                String s;
                int detectedType;
                if (matcher.start(1) != -1) {
                    detectedType = 1;
                    s = ObjectUtils.nonNullAssert(matcher.group(1));
                    detectedBaseUri = new URI(s);
                    fileName = ObjectUtils.nonNullAssert(matcher.group(2));
                } else if (matcher.start(3) != -1) {
                    detectedType = 2;
                    s = ObjectUtils.nonNullAssert(matcher.group(3));
                    detectedBaseUri = s.indexOf("!/") == -1 ? new URI(s.substring(4)) : new URI(s);
                    fileName = ObjectUtils.nonNullAssert(matcher.group(4));
                } else {
                    throw new IllegalStateException();
                }
                while (true) {
                    try {
                        detectedBaseDirectory = Paths.get(detectedBaseUri);
                    }
                    catch (FileSystemNotFoundException fileSystemNotFoundException) {
                        continue;
                    }
                    break;
                }
                detectedBaseDirectory = detectedBaseDirectory.normalize();
                ImList<Path> baseDirectories = ImCollections.newList(detectedBaseDirectory);
                if (detectedType == 1) {
                    provider = new DevBinPathEntryProvider(baseDirectories, closeables);
                } else {
                    Pattern fileNamePattern = matcher.start(5) != -1 ? JAR_VER_1_PATTERN : (matcher.start(6) != -1 ? JAR_VER_2_PATTERN : JAR_VER_0_PATTERN);
                    provider = new JarFilePathEntryProvider(baseDirectories, fileNamePattern, closeables);
                }
                closeables = null;
                BundleEntry bundleEntry = ObjectUtils.nonNullAssert(((BundleEntryProvider)provider).createEntry(((Path)baseDirectories.get(0)).resolve(fileName)));
                return bundleEntry;
            }
            throw new UnsupportedOperationException("url= " + refUrl);
        }
        finally {
            if (closeables != null) {
                BundleEntryProvider.close(closeables);
            }
        }
    }

    static void close(List<Closeable> closeables) {
        for (Closeable closeable : closeables) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommonsRuntime.log(new ErrorStatus("org.eclipse.statet.jcommons.util", "An error occurred when disposing closable of path entry provider.", e));
            }
        }
    }

    public static class DevBinPathEntryProvider
    extends BundleEntryProvider {
        public DevBinPathEntryProvider(ImList<Path> baseDirectories, List<Closeable> closeables) {
            super(baseDirectories, closeables);
        }

        @Override
        protected @Nullable BundleEntry createEntry(Path candidate) {
            Path devBin = candidate.resolve("target/classes");
            if (Files.isDirectory(devBin, new LinkOption[0])) {
                String bundleId = ObjectUtils.nonNullAssert(candidate.getFileName()).toString();
                return new BundleEntry(bundleId, devBin){

                    @Override
                    public @Nullable Path getResourcePath(String resource) {
                        Path path = super.getResourcePath(resource);
                        if (path != null) {
                            return path;
                        }
                        path = this.getPath().getParent().resolveSibling(resource);
                        if (Files.exists(path, new LinkOption[0])) {
                            return path;
                        }
                        return null;
                    }
                };
            }
            return null;
        }
    }

    public static class JarFilePathEntryProvider
    extends BundleEntryProvider {
        private final Pattern namePattern;

        public JarFilePathEntryProvider(ImList<Path> baseDirectories, Pattern namePattern, List<Closeable> closeables) {
            super(baseDirectories, closeables);
            this.namePattern = namePattern;
        }

        @Override
        protected @Nullable BundleEntry createEntry(Path candidate) {
            Matcher nameMatcher = this.namePattern.matcher(ObjectUtils.nonNullAssert(candidate.getFileName()).toString());
            if (nameMatcher.matches() && Files.isRegularFile(candidate, new LinkOption[0])) {
                String bundleId = ObjectUtils.nonNullAssert(nameMatcher.group(1));
                return new BundleEntry.Jar(bundleId, candidate);
            }
            return null;
        }

        @Nullable String getBundleId(String fileName) {
            Matcher nameMatcher = this.namePattern.matcher(fileName);
            if (nameMatcher.matches()) {
                return nameMatcher.group(1);
            }
            return null;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.namePattern.hashCode() * 17;
        }

        @Override
        public boolean equals(@Nullable Object obj) {
            return super.equals(obj) && this.namePattern.pattern().equals(((JarFilePathEntryProvider)obj).namePattern.pattern());
        }
    }
}

