/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.IWorkingBuffer;

public abstract class GenericSourceUnitWorkingCopy
implements ISourceUnit {
    private final ISourceUnit from;
    private IWorkingBuffer buffer;
    private int counter = 0;

    public GenericSourceUnitWorkingCopy(ISourceUnit from) {
        this.from = from;
    }

    @Override
    public final ISourceUnit getUnderlyingUnit() {
        return this.from;
    }

    protected final IWorkingBuffer getWorkingBuffer() {
        return this.buffer;
    }

    @Override
    public boolean isSynchronized() {
        return this.buffer.isSynchronized();
    }

    @Override
    public String getModelTypeId() {
        return this.from.getModelTypeId();
    }

    @Override
    public int getElementType() {
        return this.from.getElementType();
    }

    @Override
    public ElementName getElementName() {
        return this.from.getElementName();
    }

    @Override
    public String getId() {
        return this.from.getId();
    }

    @Override
    public boolean exists() {
        return this.counter > 0;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean checkState(boolean validate, IProgressMonitor monitor) {
        return this.buffer.checkState(validate, monitor);
    }

    @Override
    public Object getResource() {
        return this.from.getResource();
    }

    @Override
    public AbstractDocument getDocument(IProgressMonitor monitor) {
        return this.buffer.getDocument(monitor);
    }

    @Override
    public DocContentSections getDocumentContentInfo() {
        return this.from.getDocumentContentInfo();
    }

    @Override
    public long getContentStamp(IProgressMonitor monitor) {
        return this.buffer.getContentStamp(monitor);
    }

    @Override
    public SourceContent getContent(IProgressMonitor monitor) {
        return this.buffer.getContent(monitor);
    }

    @Override
    public AstInfo getAstInfo(String type, boolean ensureSync, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public ISourceUnitModelInfo getModelInfo(String type, int syncLevel, IProgressMonitor monitor) {
        return null;
    }

    @Override
    public IModelElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return false;
    }

    @Override
    public List<? extends IModelElement> getModelChildren(IModelElement.Filter filter) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public final synchronized void connect(IProgressMonitor monitor) {
        ++this.counter;
        if (this.counter == 1) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
            if (this.buffer == null) {
                m.setWorkRemaining(2);
                this.buffer = this.createWorkingBuffer(m.newChild(1));
            }
            this.register();
            this.from.connect((IProgressMonitor)m.newChild(1));
        }
    }

    @Override
    public final synchronized void disconnect(IProgressMonitor monitor) {
        --this.counter;
        if (this.counter == 0) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            this.buffer.releaseDocument((IProgressMonitor)m.newChild(1));
            this.unregister();
            this.from.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    @Override
    public synchronized boolean isConnected() {
        return this.counter > 0;
    }

    protected abstract IWorkingBuffer createWorkingBuffer(SubMonitor var1);

    protected void register() {
    }

    protected void unregister() {
    }

    public <T> T getAdapter(Class<T> adapterType) {
        return (T)this.from.getAdapter(adapterType);
    }

    public String toString() {
        return String.valueOf(this.getModelTypeId()) + '/' + this.getWorkingContext() + ": " + this.getId();
    }
}

