/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.StructureSelectionHistory;

public abstract class StructureSelectHandler
extends AbstractHandler {
    private final ISourceEditor sourceEditor;
    private final StructureSelectionHistory selectionHistory;

    protected StructureSelectHandler(ISourceEditor editor, StructureSelectionHistory history) {
        assert (editor != null);
        assert (history != null);
        this.sourceEditor = editor;
        this.selectionHistory = history;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISourceUnit su = this.sourceEditor.getSourceUnit();
        if (su == null) {
            return null;
        }
        AstInfo astInfo = su.getAstInfo(null, true, (IProgressMonitor)new NullProgressMonitor());
        if (astInfo == null) {
            return null;
        }
        ITextSelection selection = this.getTextSelection();
        IRegion newRange = this.getNewSelectionRange(selection.getOffset(), selection.getOffset() + selection.getLength(), astInfo);
        if (newRange != null) {
            this.selectionHistory.remember((IRegion)new Region(selection.getOffset(), selection.getLength()));
            try {
                this.selectionHistory.ignoreSelectionChanges();
                this.sourceEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
            }
            finally {
                this.selectionHistory.listenToSelectionChanges();
            }
        }
        return null;
    }

    public final IRegion getNewSelectionRange(int oldStart, int oldStop, AstInfo ast) {
        AstSelection selection = AstSelection.search((AstNode)ast.getRoot(), (int)oldStart, (int)oldStop, (int)1);
        if (selection.getCovering() == null) {
            return null;
        }
        return this.concreteNewSelectionRange(selection);
    }

    abstract IRegion concreteNewSelectionRange(AstSelection var1);

    protected final ITextSelection getTextSelection() {
        return (ITextSelection)this.sourceEditor.getViewer().getSelectionProvider().getSelection();
    }

    protected final IRegion createRegion(int start, int stop) {
        if (start < 0) {
            start = 0;
        }
        return new Region(start, stop - start);
    }

    public static class Enclosing
    extends StructureSelectHandler {
        public Enclosing(ISourceEditor editor, StructureSelectionHistory history) {
            super(editor, history);
        }

        @Override
        IRegion concreteNewSelectionRange(AstSelection selection) {
            AstNode covering = selection.getCovering();
            return this.createRegion(covering.getStartOffset(), covering.getEndOffset());
        }
    }

    public static class Next
    extends StructureSelectHandler {
        public Next(ISourceEditor editor, StructureSelectionHistory history) {
            super(editor, history);
        }

        @Override
        IRegion concreteNewSelectionRange(AstSelection selection) {
            AstNode covering = selection.getCovering();
            AstNode child = selection.getChildLastTouching();
            if (child == null || selection.getStopOffset() >= child.getEndOffset()) {
                child = selection.getChildAfter();
            }
            if (child != null) {
                return this.createRegion(selection.getStartOffset(), child.getEndOffset());
            }
            return this.createRegion(covering.getStartOffset(), covering.getEndOffset());
        }
    }

    public static class Previous
    extends StructureSelectHandler {
        public Previous(ISourceEditor editor, StructureSelectionHistory history) {
            super(editor, history);
        }

        @Override
        IRegion concreteNewSelectionRange(AstSelection selection) {
            AstNode covering = selection.getCovering();
            AstNode child = selection.getChildFirstTouching();
            if (child == null || selection.getStartOffset() <= child.getStartOffset()) {
                child = selection.getChildBefore();
            }
            if (child != null) {
                return this.createRegion(selection.getStopOffset(), child.getStartOffset());
            }
            return this.createRegion(covering.getEndOffset(), covering.getStartOffset());
        }
    }
}

