/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.text.ui.TextViewerAction;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.text.templates.ContextTypeRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class EditTemplateDialog
extends ExtStatusDialog {
    public static final int EDITOR_TEMPLATE = 1;
    public static final int CUSTOM_TEMPLATE = 2;
    public static final int FIX_TEMPLATE = 3;
    private final Template originalTemplate;
    private Template newTemplate;
    private final int flags;
    private final SourceEditorViewerConfigurator configurator;
    private Text nameText;
    private Text descriptionText;
    private ComboViewer contextCombo;
    private final SnippetEditor1 patternEditor;
    private Button insertVariableButton;
    private Button autoInsertCheckbox;
    private IStatus validationStatus;
    private boolean suppressError = true;
    private final ContextTypeRegistry contextTypeRegistry;
    private final TemplateVariableProcessor templateProcessor;

    public EditTemplateDialog(Shell parent, Template template, boolean edit, int flags, SourceEditorViewerConfigurator configurator, TemplateVariableProcessor processor, ContextTypeRegistry registry, String prefQualifier) {
        super(parent);
        this.setTitle(edit ? EditingMessages.EditTemplateDialog_title_Edit : EditingMessages.EditTemplateDialog_title_New);
        this.originalTemplate = template;
        this.flags = flags;
        this.templateProcessor = processor;
        this.contextTypeRegistry = registry;
        TemplateContextType type = this.contextTypeRegistry.getContextType(template.getContextTypeId());
        this.templateProcessor.setContextType(type);
        this.configurator = configurator;
        this.patternEditor = new SnippetEditor1(this.configurator, template.getPattern(), (IServiceLocator)PlatformUI.getWorkbench(), prefQualifier);
    }

    public Template getTemplate() {
        return this.newTemplate;
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.nameText == null || this.nameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(EditingMessages.EditTemplateDialog_error_NoName);
            this.updateButtonsEnableState((IStatus)status);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        dialogArea.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.suppressError = false;
                EditTemplateDialog.this.updateButtons();
            }
        };
        if ((this.flags & 0xF) == 1) {
            EditTemplateDialog.createLabel(dialogArea, EditingMessages.EditTemplateDialog_Name_label);
            Composite composite = new Composite(dialogArea, 0);
            composite.setLayoutData((Object)new GridData(768));
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)4));
            this.nameText = EditTemplateDialog.createText(composite);
            this.nameText.addModifyListener(listener);
            this.nameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditTemplateDialog.this.suppressError) {
                        EditTemplateDialog.this.suppressError = false;
                        EditTemplateDialog.this.updateButtons();
                    }
                }
            });
            EditTemplateDialog.createLabel(composite, EditingMessages.EditTemplateDialog_Context_label);
            this.contextCombo = new ComboViewer(composite, 2056);
            this.contextCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((TemplateContextType)element).getName();
                }
            });
            this.contextCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
            ArrayList<TemplateContextType> contextTypes = new ArrayList<TemplateContextType>();
            Iterator iter = this.contextTypeRegistry.contextTypes();
            while (iter.hasNext()) {
                contextTypes.add((TemplateContextType)iter.next());
            }
            this.contextCombo.setInput((Object)contextTypes.toArray());
            this.contextCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    EditTemplateDialog.this.doContextChanged((TemplateContextType)selection.getFirstElement());
                }
            });
            ViewerUtils.setDefaultVisibleItemCount((ComboViewer)this.contextCombo);
            this.autoInsertCheckbox = EditTemplateDialog.createCheckbox(composite, EditingMessages.EditTemplateDialog_AutoInsert_label);
            this.autoInsertCheckbox.setSelection(this.originalTemplate.isAutoInsertable());
        } else {
            this.configureForContext(this.getContextType());
        }
        EditTemplateDialog.createLabel(dialogArea, EditingMessages.EditTemplateDialog_Description_label);
        int descFlags = (this.flags & 0xF) == 3 ? 2056 : 2048;
        this.descriptionText = new Text(dialogArea, descFlags);
        this.descriptionText.setLayoutData((Object)new GridData(768));
        this.descriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(dialogArea, EditingMessages.EditTemplateDialog_Pattern_label);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.createEditor(dialogArea);
        Label filler = new Label(dialogArea, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
        composite.setLayoutData((Object)new GridData());
        this.insertVariableButton = new Button(composite, 0);
        this.insertVariableButton.setLayoutData((Object)new GridData(768));
        this.insertVariableButton.setText(EditingMessages.EditTemplateDialog_InsertVariable);
        this.insertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.insertVariablePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.descriptionText.setText(this.originalTemplate.getDescription());
        if (this.nameText != null) {
            this.nameText.setText(this.originalTemplate.getName());
            this.nameText.addModifyListener(listener);
            this.contextCombo.setSelection((ISelection)new StructuredSelection((Object)this.contextTypeRegistry.getContextType(this.originalTemplate.getContextTypeId())));
        } else {
            this.patternEditor.getControl().setFocus();
        }
        TextViewerAction assistAction = new TextViewerAction((ITextViewer)this.patternEditor.getSourceViewer(), 13);
        assistAction.setId("ContentAssistProposal");
        assistAction.setText(EditingMessages.EditTemplateDialog_ContentAssist);
        assistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.patternEditor.addAction(assistAction);
        LayoutUtils.addSmallFiller((Composite)dialogArea, (boolean)false);
        EditTemplateDialog.applyDialogFont((Control)dialogArea);
        return composite;
    }

    protected SourceViewer getSourceViewer() {
        return this.patternEditor.getSourceViewer();
    }

    protected SourceEditorViewerConfigurator getSourceViewerConfigurator() {
        return this.configurator;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private void createEditor(Composite parent) {
        int nLines = this.patternEditor.getDocument().getNumberOfLines();
        if (nLines < 6) {
            nLines = 6;
        } else if (nLines > 12) {
            nLines = 12;
        }
        this.patternEditor.create(parent, 0x2000B02);
        Composite control = this.patternEditor.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        this.patternEditor.getSourceViewer().addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditTemplateDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
    }

    private void doContextChanged(TemplateContextType contextType) {
        this.templateProcessor.setContextType(contextType);
        this.configureForContext(contextType);
        Document document = this.patternEditor.getDocument();
        this.doValidate(contextType, (IDocument)document);
        this.updateButtons();
    }

    private void doSourceChanged(IDocument document) {
        TemplateContextType contextType = this.getContextType();
        this.doValidate(contextType, document);
        this.updateButtons();
    }

    private void doValidate(TemplateContextType contextType, IDocument document) {
        IStatus status;
        String text = document.get();
        this.validationStatus = null;
        if (contextType != null && (status = this.validate(contextType, text)) != null && !status.isOK()) {
            this.validationStatus = status;
        }
    }

    protected IStatus validate(TemplateContextType contextType, String text) {
        try {
            contextType.validate(text);
            return ValidationStatus.ok();
        }
        catch (TemplateException e) {
            return ValidationStatus.error((String)e.getLocalizedMessage());
        }
    }

    protected void configureForContext(TemplateContextType contextType) {
    }

    protected void insertVariablePressed() {
        this.patternEditor.getSourceViewer().getTextWidget().setFocus();
        this.patternEditor.getSourceViewer().doOperation(13);
    }

    protected void insertText(String text) {
        this.patternEditor.getSourceViewer().getTextWidget().insert(text);
    }

    protected void okPressed() {
        String name = this.nameText == null ? this.originalTemplate.getName() : this.nameText.getText();
        boolean isAutoInsertable = this.autoInsertCheckbox != null && this.autoInsertCheckbox.getSelection();
        this.newTemplate = new Template(name, this.descriptionText.getText(), this.getContextType().getId(), this.patternEditor.getDocument().get(), isAutoInsertable);
        super.okPressed();
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.nameText == null || this.nameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo info = new StatusInfo();
            if (!this.suppressError) {
                info.setError(EditingMessages.EditTemplateDialog_error_NoName);
            }
            status = info;
        } else if (!this.isValidPattern(this.patternEditor.getDocument().get())) {
            StatusInfo info = new StatusInfo();
            if (!this.suppressError) {
                info.setError(EditingMessages.EditTemplateDialog_error_invalidPattern);
            }
            status = info;
        } else {
            status = this.validationStatus != null ? this.validationStatus : ValidationStatus.ok();
        }
        this.updateStatus((IStatus)status);
    }

    protected boolean isValidPattern(String pattern) {
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch != '\t' && ch != '\n' && ch != '\r' && ch < ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected TemplateContextType getContextType() {
        if (this.contextCombo != null) {
            StructuredSelection selection = (StructuredSelection)this.contextCombo.getSelection();
            return (TemplateContextType)selection.getFirstElement();
        }
        return this.contextTypeRegistry.getContextType(this.originalTemplate.getContextTypeId());
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)LTKUIPlugin.getInstance(), (String)"TemplateEditDialog");
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }
}

