/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.preferences;

import java.util.EnumSet;
import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.nico.ui.preferences.ConsolePreferences;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.ui.NicoUIPreferences;
import org.eclipse.statet.nico.ui.util.SubmitTypeSelectionComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
class ConsolePreferenceBlock
extends ManagedConfigurationBlock {
    private SubmitTypeSelectionComposite inputSubmitTypeControl;
    private Text outputCharLimitControl;
    private SubmitTypeSelectionComposite outputSubmitTypeControl;

    public ConsolePreferenceBlock(@Nullable StatusChangeListener statusListener) {
        super(null, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, @Nullable String> prefs = new HashMap<Object, String>();
        prefs.put(ConsolePreferences.HISTORYNAVIGATION_SUBMIT_TYPES_PREF, "nico.console");
        prefs.put(NicoUIPreferences.OUTPUT_CHARLIMIT_PREF, "nico.console");
        prefs.put(NicoUIPreferences.OUTPUT_FILTER_SUBMITTYPES_INCLUDE_PREF, "nico.console");
        this.setupPreferenceManager(prefs);
        Composite appearance = this.createOutputOptions(pageComposite);
        appearance.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite input = this.createInputOptions(pageComposite);
        input.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initBindings();
        this.updateControls();
    }

    private Composite createInputOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Input:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false));
        label.setText("Include in &history navigation (up/down) input from:");
        this.inputSubmitTypeControl = new SubmitTypeSelectionComposite((Composite)group);
        this.inputSubmitTypeControl.setLayoutData(new GridData(16384, 4, true, true));
        return group;
    }

    private Composite createOutputOptions(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Output:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("S&ize (characters):");
        Text text = new Text((Composite)group, 133120);
        GridData gd = new GridData(16384, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)12);
        text.setLayoutData((Object)gd);
        text.setTextLimit(20);
        this.outputCharLimitControl = text;
        LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        label.setText("&Print content from:");
        this.outputSubmitTypeControl = new SubmitTypeSelectionComposite((Composite)group);
        this.outputSubmitTypeControl.setLayoutData(new GridData(16384, 4, true, true, 2, 1));
        this.outputSubmitTypeControl.setEditable(EnumSet.of(SubmitType.OTHER));
        return group;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.outputCharLimitControl), this.createObservable(NicoUIPreferences.OUTPUT_CHARLIMIT_PREF), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(100000, 1000000000, "Invalid char limit specified (100000, 1000000000).")), null);
        db.getContext().bindValue(this.outputSubmitTypeControl.getObservable(), this.createObservable(NicoUIPreferences.OUTPUT_FILTER_SUBMITTYPES_INCLUDE_PREF));
        db.getContext().bindValue(this.inputSubmitTypeControl.getObservable(), this.createObservable(ConsolePreferences.HISTORYNAVIGATION_SUBMIT_TYPES_PREF));
    }
}

