/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.launching;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigPresets;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithPresets;
import org.eclipse.statet.ecommons.templates.TemplateVariableProcessor;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.components.CustomizableVariableSelectionDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableTextValidator;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.r.apps.ui.Messages;
import org.eclipse.statet.internal.r.apps.ui.launching.AppControlConfigs;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SnippetEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.ui.sourceediting.RTemplateSourceViewerConfigurator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public class AppControlConfigMainTab
extends LaunchConfigTabWithPresets {
    private final IObservableValue<String> appPathValue;
    private final IObservableValue<String> appHostValue;
    private final IObservableValue<@Nullable Integer> appPortValue;
    private final IObservableValue<Boolean> startStopRunningValue;
    private final IObservableValue<String> startRSnippetValue;
    private final IObservableValue<String> stopRSnippetValue;
    private Text sHostControl;
    private Text sPortControl;
    private Button startStopRunningControl;
    private VariableText2 rSnippetVariableResolver;
    private SnippetEditor startRSnippetEditor;
    private SnippetEditor stopRSnippetEditor;

    static void initDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.eclipse.statet.r.apps/Start.StopBlockingTasks.mode", 1);
    }

    public AppControlConfigMainTab(LaunchConfigPresets presets) {
        Realm realm = this.getRealm();
        this.appHostValue = new WritableValue(realm, null, String.class);
        this.appPortValue = new WritableValue(realm, null, Integer.class);
        this.appPathValue = new WritableValue(realm, null, String.class);
        this.startRSnippetValue = new WritableValue(realm, null, String.class);
        this.startStopRunningValue = new WritableValue(realm, null, Boolean.class);
        this.stopRSnippetValue = new WritableValue(realm, null, String.class);
        this.setPresets(presets);
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/main_tab");
    }

    public String getName() {
        return Messages.Operation_MainTab_name;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        mainComposite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        this.addPresetsButton(mainComposite);
        Composite composite = this.createAddressSettings(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite = this.createSnippetSettings(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    private Composite createAddressSettings(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.Operation_MainTab_AppAddress_group);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        Label label = new Label((Composite)composite, 16384);
        label.setText(String.valueOf(Messages.Operation_MainTab_AppHost_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text((Composite)composite, 18436);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.sHostControl = text;
        Label info = new Label((Composite)composite, 16384);
        info.setText(Messages.Operation_AppHost_info);
        info.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label((Composite)composite, 16384);
        label.setText(String.valueOf(Messages.Operation_MainTab_AppPort_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text number = new Text((Composite)composite, 18436);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)number, (int)5);
        number.setLayoutData((Object)gd);
        this.sPortControl = number;
        Label info2 = new Label((Composite)composite, 16384);
        info2.setText(Messages.Operation_AppPort_info);
        info2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        return composite;
    }

    private Map<String, IStringVariable> createSnippetVariables() {
        HashMap<String, IStringVariable> variables = new HashMap<String, IStringVariable>();
        VariableUtils.add(variables, (IStringVariable)AppControlConfigs.APP_HOST_VAR);
        VariableUtils.add(variables, (IStringVariable)AppControlConfigs.APP_PORT_VAR);
        return variables;
    }

    private Composite createSnippetSettings(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(Messages.Operation_MainTab_Start_group);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        this.rSnippetVariableResolver = new VariableText2(this.createSnippetVariables());
        Label label = new Label((Composite)composite, 0);
        label.setText(String.valueOf(Messages.Operation_StartApp_RCode_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        TemplateVariableProcessor templateVariableProcessor = new TemplateVariableProcessor();
        RTemplateSourceViewerConfigurator configurator = new RTemplateSourceViewerConfigurator(RCore.getWorkbenchAccess(), templateVariableProcessor);
        SnippetEditor1 editor = new SnippetEditor1((SourceEditorViewerConfigurator)configurator, null, (IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.statet.r.ui/launchingconfig", true){

            protected void fillToolMenu(Menu menu) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText(SharedMessages.InsertVariable_label);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        CustomizableVariableSelectionDialog dialog = new CustomizableVariableSelectionDialog(this.getTextControl().getShell());
                        dialog.addVariableFilter(VariableFilterUtils.EXCLUDE_JAVA_FILTER);
                        dialog.setAdditionals(AppControlConfigMainTab.this.rSnippetVariableResolver.getExtraVariables().values());
                        if (dialog.open() != 0) {
                            return;
                        }
                        String variable = dialog.getVariableExpression();
                        if (variable == null) {
                            return;
                        }
                        this.getTextControl().insert(variable);
                        this.getTextControl().setFocus();
                    }
                });
            }
        };
        editor.create((Composite)composite, 0x2000B02);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = LayoutUtils.hintHeight((StyledText)editor.getSourceViewer().getTextWidget(), (int)8);
        editor.getControl().setLayoutData((Object)gd);
        this.startRSnippetEditor = editor;
        Button button = new Button((Composite)composite, 32);
        button.setText(Messages.Operation_StartApp_StopRunningApp_label);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.startStopRunningControl = button;
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        label = new Label((Composite)composite, 0);
        label.setText(String.valueOf(Messages.Operation_StopApp_RCode_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        templateVariableProcessor = new TemplateVariableProcessor();
        configurator = new RTemplateSourceViewerConfigurator(RCore.getWorkbenchAccess(), templateVariableProcessor);
        editor = new SnippetEditor1((SourceEditorViewerConfigurator)configurator, null, (IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.statet.r.ui/launchingconfig");
        editor.create((Composite)composite, 33556484);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = LayoutUtils.hintHeight((StyledText)editor.getSourceViewer().getTextWidget(), (int)1);
        editor.getControl().setLayoutData((Object)gd);
        this.stopRSnippetEditor = editor;
        return composite;
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.sHostControl), this.appHostValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.sPortControl), this.appPortValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(0, 65535, true, Messages.Operation_AppPort_error_SpecInvalid_message)), null);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.startRSnippetEditor.getTextControl()), this.startRSnippetValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)new VariableTextValidator(this.rSnippetVariableResolver, Messages.Operation_StartApp_RCode_error_SpecInvalid_message))), null);
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.startStopRunningControl), this.startStopRunningValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.stopRSnippetEditor.getTextControl()), this.stopRSnippetValue);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        AppControlConfigMainTab.initDefaults(configuration);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        String text = this.readAttribute(configuration, "org.eclipse.statet.r.apps/App.host", "");
        this.appHostValue.setValue((Object)text);
        int port = this.readAttribute(configuration, "org.eclipse.statet.r.apps/App.port", 0);
        this.appPortValue.setValue((Object)(port != 0 ? Integer.valueOf(port) : null));
        int mode = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Start.StopBlockingTasks.mode", 0);
        this.startStopRunningValue.setValue((Object)(mode > 0 ? 1 : 0));
        String code = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Start.RSnippet.code", "");
        this.startRSnippetValue.setValue((Object)code);
        code = this.readAttribute(configuration, "org.eclipse.statet.r.apps/Stop.RSnippet.code", "");
        this.stopRSnippetValue.setValue((Object)code);
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        String text = (String)this.appHostValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/App.host", text);
        Integer port = (Integer)this.appPortValue.getValue();
        if (port != null) {
            configuration.setAttribute("org.eclipse.statet.r.apps/App.port", port.intValue());
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.apps/App.port");
        }
        int mode = (Boolean)this.startStopRunningValue.getValue() != false ? 1 : 0;
        configuration.setAttribute("org.eclipse.statet.r.apps/Start.StopBlockingTasks.mode", mode);
        String code = (String)this.startRSnippetValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/Start.RSnippet.code", code);
        code = (String)this.stopRSnippetValue.getValue();
        configuration.setAttribute("org.eclipse.statet.r.apps/Stop.RSnippet.code", code);
    }
}

