/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.apps.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.apps.ui.RApp;

@NonNullByDefault
public class AppRegistry {
    public static final byte APP_STARTED = 1;
    public static final byte APP_STOPPED = 2;
    private static final AppRegistry INSTANCE = new AppRegistry();
    private final Map<URL, AppEntry> sessions = new HashMap<URL, AppEntry>();
    private final CopyOnWriteIdentityListSet<Listener> listeners = new CopyOnWriteIdentityListSet();

    public static AppRegistry getInstance() {
        return INSTANCE;
    }

    public void addListener(Listener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners(AppStateEvent event) {
        for (Listener listener : this.listeners) {
            listener.onAppStateChanged(event);
        }
    }

    public synchronized void onAppStarted(URL id, RApp app) {
        AppEntry entry = this.sessions.computeIfAbsent(id, AppEntry::new);
        if (entry.isRunning) {
            this.notifyListeners(new AppStateEvent(2, id, entry.app));
        }
        entry.app = app;
        entry.isRunning = true;
        this.notifyListeners(new AppStateEvent(1, id, app));
    }

    public synchronized void onAppStopped(URL id, RApp app) {
        AppEntry entry = this.sessions.get(id);
        if (entry != null && entry.app == app) {
            entry.isRunning = false;
            this.notifyListeners(new AppStateEvent(2, id, app));
        }
    }

    public synchronized @Nullable RApp getApp(URL id) {
        AppEntry entry = this.sessions.get(id);
        return entry != null ? entry.app : null;
    }

    public synchronized @Nullable RApp getApp(Tool tool) {
        for (AppEntry entry : this.sessions.values()) {
            if (!entry.isRunning || entry.app.getTool() != tool) continue;
            return entry.app;
        }
        return null;
    }

    private static class AppEntry {
        private final URL id;
        private RApp app;
        private boolean isRunning;

        public AppEntry(URL id) {
            this.id = id;
        }
    }

    public static class AppStateEvent
    extends RApp.AppEvent {
        private final byte type;
        private final URL id;

        public AppStateEvent(byte type, URL id, RApp app) {
            super(app);
            this.type = type;
            this.id = id;
        }

        public byte getType() {
            return this.type;
        }

        public URL getId() {
            return this.id;
        }
    }

    public static interface Listener {
        public void onAppStateChanged(AppStateEvent var1);
    }
}

