/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.nico.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.statet.internal.r.console.core.RConsoleCorePlugin;
import org.eclipse.statet.internal.r.nico.RNicoMessages;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolCommandHandler;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.IRequireSynch;
import org.eclipse.statet.nico.core.runtime.Prompt;
import org.eclipse.statet.nico.core.runtime.Queue;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolStatus;
import org.eclipse.statet.nico.core.runtime.ToolStreamMonitor;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.r.console.core.AbstractRController;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.nico.impl.RTermCancelRunnable;

public class RTermController
extends AbstractRController
implements IRequireSynch {
    private static final Pattern INT_OUTPUT_PATTERN = Pattern.compile("\\Q[1] \\E(\\d*)");
    private static final Pattern STRING_OUTPUT_PATTERN = Pattern.compile("\\Q[1] \"\\E((?:\\Q\\\"\\E|[^\"])*)\\\"");
    private final ProcessBuilder fConfig;
    private final Charset fCharset;
    private Process fProcess;
    private OutputStreamWriter fProcessInputWriter;
    private BufferedInputStream fProcessOutputBuffer;
    private InputStreamReader fProcessOutputReader;
    private ReadThread fProcessOutputThread;
    Long fProcessId;

    public RTermController(RProcess process, ProcessBuilder config, Charset charset) {
        super(process, null);
        this.fConfig = config;
        this.fCharset = charset;
        this.setWorksapceData(new RWorkspace(this, null, null){

            @Override
            protected void refreshFromTool(AbstractRController controller, int options, ProgressMonitor m) throws StatusException {
                Matcher matcher;
                StringBuilder output;
                if (((options & 2) != 0 || (options & 1) == 0) && (output = RTermController.this.readOutputLine("getwd()", m)) != null && (matcher = STRING_OUTPUT_PATTERN.matcher(output)).find()) {
                    String wd = matcher.group(1);
                    RTermController.this.setWorkspaceDirL(EFS.getLocalFileSystem().getStore((IPath)new Path(wd)));
                }
                this.clearBriefedChanges();
            }
        });
        this.setWorkspaceDirL(EFS.getLocalFileSystem().fromLocalFile(config.directory()));
        this.initRunnableAdapterL();
    }

    protected ToolRunnable createStartRunnable() {
        return new ToolController.StartRunnable(this){

            public String getLabel() {
                return RNicoMessages.Rterm_StartTask_label;
            }
        };
    }

    protected void startToolL(ProgressMonitor m) throws StatusException {
        OutputStream processInput = null;
        try {
            this.fConfig.redirectErrorStream(true);
            this.fProcess = this.fConfig.start();
            InputStream processOutput = this.fProcess.getInputStream();
            if (processOutput instanceof BufferedInputStream) {
                this.fProcessOutputBuffer = (BufferedInputStream)processOutput;
            }
            this.fProcessOutputReader = new InputStreamReader(processOutput, this.fCharset);
            this.fProcessOutputThread = new ReadThread();
            this.fProcessOutputThread.start();
            processInput = this.fProcess.getOutputStream();
            this.fProcessInputWriter = new OutputStreamWriter(processInput, this.fCharset);
            this.setCurrentPromptL(this.fDefaultPrompt);
            final ArrayList<Status> warnings = new ArrayList<Status>();
            this.initTracks(this.fConfig.directory().toString(), m, warnings);
            this.getQueue().add((ToolRunnable)new UpdateProcessIdTask());
            if (!this.startupsRunnables.isEmpty()) {
                this.getQueue().add(this.startupsRunnables);
                this.startupsRunnables.clear();
            }
            this.scheduleControllerRunnable((SystemRunnable)new ToolController.ControllerSystemRunnable(this, "r/rj/start2", "Finish Initialization"){

                public void run(ToolService service, ProgressMonitor m) throws StatusException {
                    for (Status status : warnings) {
                        RTermController.this.handleStatus(status, m);
                    }
                }
            });
        }
        catch (IOException e) {
            if (processInput != null) {
                try {
                    processInput.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.r.console.core", RNicoMessages.RTerm_error_Starting_message, (Throwable)e));
        }
    }

    protected void interruptTool() {
        this.runSendCtrlC();
    }

    @Override
    protected void postCancelTask(int options, ProgressMonitor m) throws StatusException {
        this.fCurrentInput = "";
        this.doSubmitL(m);
        this.fCurrentInput = "";
        this.doSubmitL(m);
    }

    protected void killTool(ProgressMonitor m) {
        Process p = this.fProcess;
        if (p != null) {
            p.destroy();
            this.fProcess = null;
        }
    }

    protected boolean isToolAlive() {
        Process p = this.fProcess;
        if (p != null) {
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                return true;
            }
        }
        return false;
    }

    protected void clear() {
        this.fProcess = null;
        super.clear();
    }

    private boolean runSendCtrlC() {
        if (!Platform.getOS().startsWith("win") || this.getStatus() == ToolStatus.TERMINATED) {
            return false;
        }
        ToolCommandHandler handler = this.getCommandHandler("common/runBlocking");
        if (handler != null) {
            RTermCancelRunnable cancelRunnable = new RTermCancelRunnable();
            Map<String, RTermCancelRunnable> data = Collections.singletonMap("runnable", cancelRunnable);
            Status status = this.executeHandler("common/runBlocking", handler, data, null);
            return status != null && status.getSeverity() == 0;
        }
        return false;
    }

    protected void doBeforeSubmitL() {
        ToolStreamProxy streams = this.getStreams();
        SubmitType submitType = this.getCurrentSubmitType();
        try {
            this.fProcessOutputThread.streamLock.lock();
            streams.getInputStreamMonitor().append(this.fCurrentInput, submitType, this.fCurrentPrompt.meta & 1);
            streams.getInputStreamMonitor().append(this.getWorkspaceData().getLineSeparator(), submitType, 1);
        }
        finally {
            this.fProcessOutputThread.streamLock.unlock();
        }
    }

    protected void doSubmitL(ProgressMonitor m) {
        block4: {
            m.beginSubTask(String.valueOf(this.fDefaultPrompt.text) + " " + this.fCurrentInput);
            try {
                this.fProcessInputWriter.write(String.valueOf(this.fCurrentInput) + this.fLineSeparator);
                this.fProcessInputWriter.flush();
            }
            catch (IOException e) {
                RConsoleCorePlugin.logError("Rterm IO error", e);
                if (this.isToolAlive()) break block4;
                this.markAsTerminated();
                this.setCurrentPromptL(Prompt.NONE);
                return;
            }
        }
        try {
            Thread.sleep(this.fProcessOutputThread.SYNC_MS * 2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fProcessOutputThread.streamLock.lock();
        this.fProcessOutputThread.streamLock.unlock();
        this.setCurrentPromptL(this.fDefaultPrompt);
    }

    public Pattern synch(ProgressMonitor m) throws StatusException {
        final ToolStreamMonitor stream = this.getStreams().getOutputStreamMonitor();
        final String stamp = "Synch" + System.nanoTime();
        final AtomicBoolean patternFound = new AtomicBoolean(false);
        IStreamListener listener = new IStreamListener(){
            private String lastLine = "";

            public void streamAppended(String text, IStreamMonitor monitor) {
                if (text.contains(stamp)) {
                    this.found();
                    return;
                }
                String[] lines = RUtil.LINE_SEPARATOR_PATTERN.split(text, -1);
                if ((String.valueOf(this.lastLine) + lines[0]).contains(stamp)) {
                    this.found();
                    return;
                }
                this.lastLine = lines[lines.length - 1];
            }

            private void found() {
                stream.removeListener((IStreamListener)this);
                patternFound.set(true);
            }
        };
        try {
            stream.addListener(listener);
            this.submitToConsole("cat(\"" + stamp + "\\n\");", m);
            while (!patternFound.get()) {
                if (m.isCanceled()) {
                    throw this.cancelTask();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            Pattern pattern = Pattern.compile("(?:" + Pattern.quote(this.getWorkspaceData().getDefaultPrompt().text) + ")?" + stamp);
            return pattern;
        }
        finally {
            stream.removeListener(listener);
        }
    }

    private StringBuilder readOutputLine(String command, ProgressMonitor m) throws StatusException {
        final ToolStreamMonitor stream = this.getStreams().getOutputStreamMonitor();
        final StringBuilder output = new StringBuilder();
        final AtomicBoolean patternFound = new AtomicBoolean(false);
        IStreamListener listener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                Matcher matcher = RUtil.LINE_SEPARATOR_PATTERN.matcher(text);
                if (matcher.find()) {
                    output.append(text.substring(0, matcher.start()));
                    this.found();
                } else {
                    output.append(text);
                }
            }

            private void found() {
                stream.removeListener((IStreamListener)this);
                patternFound.set(true);
            }
        };
        this.synch(m);
        try {
            stream.addListener(listener);
            if (m.isCanceled()) {
                return null;
            }
            this.submitToConsole(command, m);
            while (!patternFound.get()) {
                if (m.isCanceled()) {
                    throw this.cancelTask();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            StringBuilder stringBuilder = output;
            return stringBuilder;
        }
        finally {
            stream.removeListener(listener);
        }
    }

    static /* synthetic */ InputStreamReader access$0(RTermController rTermController) {
        return rTermController.fProcessOutputReader;
    }

    static /* synthetic */ Process access$1(RTermController rTermController) {
        return rTermController.fProcess;
    }

    static /* synthetic */ BufferedInputStream access$2(RTermController rTermController) {
        return rTermController.fProcessOutputBuffer;
    }

    static /* synthetic */ Thread access$3(RTermController rTermController) {
        return rTermController.getControllerThread();
    }

    private class ReadThread
    extends Thread {
        volatile int hasNoOutput;
        private final int SYNC_COUNT = 2;
        private final int SYNC_MS = 33;
        final Lock streamLock;

        public ReadThread() {
            super("Rterm-Output Monitor");
            this.SYNC_COUNT = 2;
            this.SYNC_MS = 33;
            this.streamLock = new ReentrantLock();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 15[WHILELOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRTerminated() {
            RTermController.this.markAsTerminated();
            Queue queue = RTermController.this.getQueue();
            synchronized (queue) {
                RTermController.this.getQueue().notifyAll();
            }
        }
    }

    private class UpdateProcessIdTask
    extends ToolController.ControllerSystemRunnable
    implements SystemRunnable {
        public UpdateProcessIdTask() {
            super((ToolController)RTermController.this, "r/rterm/fetch-process-id", "Fetch Process Id");
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            Matcher matcher;
            StringBuilder output = RTermController.this.readOutputLine("Sys.getpid()", m);
            if (output != null && (matcher = INT_OUTPUT_PATTERN.matcher(output)).find()) {
                String idString = matcher.group(1);
                if (idString != null) {
                    try {
                        RTermController.this.fProcessId = Long.valueOf(idString);
                    }
                    catch (NumberFormatException e) {
                        RTermController.this.fProcessId = null;
                    }
                } else {
                    RTermController.this.fProcessId = null;
                }
            }
        }
    }
}

