/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.sourcemodel;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.internal.r.core.sourcemodel.RModelManager;
import org.eclipse.statet.internal.r.core.sourcemodel.SourceAnalyzer;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.string.InternStringCache;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.input.OffsetStringParserInput;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.SourceModelStamp;
import org.eclipse.statet.r.core.model.IRModelInfo;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RChunkElement;
import org.eclipse.statet.r.core.model.RProblemReporter;
import org.eclipse.statet.r.core.model.RSuModelContainer;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.statet.r.core.rsource.ast.RoxygenScanner;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;

public class RReconciler {
    private static final boolean LOG_TIME = false;
    private final RModelManager rManager;
    protected boolean stop = false;
    private final Object raLock = new Object();
    private final StringFactory raAstStringCache;
    private final StringParserInput raInput = new StringParserInput(4096);
    private final RoxygenScanner raRoxygenScanner;
    private final Object rmLock = new Object();
    private final SourceAnalyzer rmScopeAnalyzer;
    private final Object rpLock = new Object();
    private final RProblemReporter rpReporter;

    public RReconciler(RModelManager manager) {
        this.rManager = manager;
        this.raAstStringCache = new InternStringCache(32);
        this.raRoxygenScanner = new RoxygenScanner(this.raAstStringCache);
        this.rmScopeAnalyzer = new SourceAnalyzer();
        this.rpReporter = new RProblemReporter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconcile(RSuModelContainer adapter, int flags, IProgressMonitor monitor) {
        int type;
        IRSourceUnit su = (IRSourceUnit)adapter.getSourceUnit();
        int n = type = su.getModelTypeId().equals("R") ? su.getElementType() : 0;
        if (type == 0) {
            return;
        }
        Data data = new Data(adapter, monitor);
        if (data.content == null) {
            return;
        }
        Object object = this.raLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            this.updateAst(data, monitor);
        }
        if (this.stop || monitor.isCanceled() || (flags & 0xF) < 2) {
            return;
        }
        object = this.rmLock;
        synchronized (object) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            boolean updated = this.updateModel(data);
            if (this.stop) {
                return;
            }
            if (updated) {
                this.rManager.getEventJob().addUpdate((IModelElement)su, data.oldModel, data.newModel);
            }
        }
        if ((flags & 0x2000000) != 0 && data.newModel != null) {
            if (this.stop || monitor.isCanceled()) {
                return;
            }
            ProblemRequestor problemRequestor = null;
            Object object2 = this.rpLock;
            synchronized (object2) {
                if (!this.stop && !monitor.isCanceled() && data.newModel == adapter.getCurrentModel() && (problemRequestor = adapter.createProblemRequestor()) != null) {
                    this.rpReporter.run(su, data.content, (RAstNode)data.ast.getRoot(), problemRequestor);
                }
            }
            if (problemRequestor != null) {
                problemRequestor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRModelInfo reconcile(IRSourceUnit su, ISourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes, int level, IProgressMonitor monitor) {
        Object object = this.rmLock;
        synchronized (object) {
            return this.updateModel(su, modelInfo, chunkElements, inlineNodes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateAst(Data data, IProgressMonitor monitor) {
        SourceModelStamp stamp = new SourceModelStamp(data.content.getStamp());
        data.ast = data.adapter.getCurrentAst();
        if (data.ast != null && !stamp.equals((Object)data.ast.getStamp())) {
            data.ast = null;
        }
        if (data.ast == null) {
            long startAst = System.nanoTime();
            Object input = data.content.getStartOffset() != 0 ? new OffsetStringParserInput(data.content.getText(), data.content.getStartOffset()) : this.raInput.reset(data.content.getText());
            RScanner scanner = new RScanner(4, this.raAstStringCache);
            scanner.setCommentLevel(100);
            SourceComponent sourceComponent = scanner.scanSourceRange(input.init(data.content.getStartOffset(), data.content.getEndOffset()), null);
            data.ast = new AstInfo(scanner.getAstLevel(), (ISourceModelStamp)stamp, (AstNode)sourceComponent);
            long stopAst = System.nanoTime();
            this.raRoxygenScanner.init(input.init(data.content.getStartOffset(), data.content.getEndOffset()));
            this.raRoxygenScanner.update(sourceComponent);
            RSuModelContainer rSuModelContainer = data.adapter;
            synchronized (rSuModelContainer) {
                data.adapter.setAst(data.ast);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean updateModel(Data data) {
        data.newModel = (IRModelInfo)data.adapter.getCurrentModel();
        if (data.newModel != null && !data.ast.getStamp().equals(data.newModel.getStamp())) {
            data.newModel = null;
        }
        if (data.newModel == null) {
            long startModel = System.nanoTime();
            IRModelInfo model = this.rmScopeAnalyzer.createModel((IRSourceUnit)data.adapter.getSourceUnit(), data.ast);
            boolean isOK = model != null;
            long stopModel = System.nanoTime();
            if (isOK) {
                RSuModelContainer rSuModelContainer = data.adapter;
                synchronized (rSuModelContainer) {
                    data.oldModel = (IRModelInfo)data.adapter.getCurrentModel();
                    data.adapter.setModel(model);
                }
                data.newModel = model;
                return true;
            }
        }
        return false;
    }

    private IRModelInfo updateModel(IRSourceUnit su, ISourceUnitModelInfo modelInfo, List<? extends RChunkElement> chunkElements, List<? extends SourceComponent> inlineNodes) {
        IRModelInfo model;
        try {
            AstInfo ast = modelInfo.getAst();
            this.rmScopeAnalyzer.beginChunkSession(su, ast);
            for (RChunkElement rChunkElement : chunkElements) {
                Object rootNodes;
                SourceComponent source = rChunkElement.getAdapter(SourceComponent.class);
                if (source instanceof SourceComponent) {
                    rootNodes = ImCollections.newList((Object)((Object)source));
                } else {
                    if (!(source instanceof List)) continue;
                    rootNodes = (List)((Object)source);
                }
                this.rmScopeAnalyzer.processChunk(rChunkElement, (List<SourceComponent>)rootNodes);
            }
            for (SourceComponent sourceComponent : inlineNodes) {
                this.rmScopeAnalyzer.processInlineNode(sourceComponent);
            }
        }
        finally {
            model = this.rmScopeAnalyzer.stopChunkSession();
        }
        return model;
    }

    void stop() {
        this.stop = true;
    }

    protected static class Data {
        public final RSuModelContainer adapter;
        public final SourceContent content;
        public AstInfo ast;
        public IRModelInfo oldModel;
        public IRModelInfo newModel;

        public Data(RSuModelContainer adapter, IProgressMonitor monitor) {
            this.adapter = adapter;
            this.content = adapter.getParseContent(monitor);
        }
    }
}

