/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.editors;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.ecommons.ui.workbench.AbstractEditorOutlinePage;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.editors.WikidocRweaveRefactoringFactory;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.sourceediting.DocROutlineContentProvider;
import org.eclipse.statet.ltk.model.core.elements.IEmbeddedForeignElement;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.ui.sourceediting.OutlineContentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor2OutlinePage;
import org.eclipse.statet.ltk.ui.util.ViewerDragSupport;
import org.eclipse.statet.ltk.ui.util.ViewerDropSupport;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.statet.redocs.wikitext.r.ui.WikitextRweaveLabelProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;

public class WikidocRweaveOutlinePage
extends SourceEditor2OutlinePage {
    private static final String EXPAND_ELEMENTS_COMMAND_ID = "org.eclipse.statet.workbench.commands.ExpandElements";
    private static Map<String, String> H2_PARAMETERS = Collections.singletonMap("type", "h2");
    private static Map<String, String> H3_PARAMETERS = Collections.singletonMap("type", "h3");
    private static Map<String, String> H4_PARAMETERS = Collections.singletonMap("type", "h4");
    private static Map<String, String> RCHUNK_PARAMETERS = Collections.singletonMap("type", "rchunks");
    private final ContentFilter filter = new ContentFilter();

    private static boolean isRChunk(IModelElement element) {
        ISourceStructElement foreignElement;
        return element instanceof IEmbeddedForeignElement && (foreignElement = ((IEmbeddedForeignElement)element).getForeignElement()) != null && foreignElement.getModelTypeId() == "R";
    }

    public WikidocRweaveOutlinePage(SourceEditor1 editor) {
        super(editor, "Wikidoc", (CommonRefactoringFactory)WikidocRweaveRefactoringFactory.getInstance(), "org.eclipse.statet.docmlet.menus.WikidocOutlineViewContextMenu");
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)RedocsWikitextRPlugin.getInstance(), (String)"WikidocRweaveOutlineView");
    }

    protected OutlineContentProvider createContentProvider() {
        return new DocROutlineContentProvider((OutlineContentProvider.IOutlineContent)new SourceEditor1OutlinePage.OutlineContent((SourceEditor1OutlinePage)this));
    }

    protected IModelElement.Filter getContentFilter() {
        return this.filter;
    }

    protected void configureViewer(TreeViewer viewer) {
        super.configureViewer(viewer);
        viewer.setLabelProvider((IBaseLabelProvider)new WikitextRweaveLabelProvider(0));
        ViewerDropSupport drop = new ViewerDropSupport((StructuredViewer)viewer, (IAdaptable)this, this.getRefactoringFactory());
        drop.init();
        ViewerDragSupport drag = new ViewerDragSupport((StructuredViewer)viewer);
        drag.init();
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
        super.initActions(serviceLocator, handlers);
        IHandlerService handlerService = (IHandlerService)serviceLocator.getService(IHandlerService.class);
        handlers.add(".FilterRChunks", (IHandler2)new FilterRChunks());
        ExpandElementsHandler handler = new ExpandElementsHandler();
        handlers.add(EXPAND_ELEMENTS_COMMAND_ID, (IHandler2)handler);
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        RedocsRUIResources redocsResources = RedocsRUIResources.INSTANCE;
        toolBarManager.appendToGroup("view.expand", (IContributionItem)new ExpandElementsContributionItem(serviceLocator, handlers));
        toolBarManager.appendToGroup("view.filter", (IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(serviceLocator, null, "NO_COMMAND", null, redocsResources.getImageDescriptor("org.eclipse.statet.redocs.r/image/loctool/filter-r_chunks"), null, null, "Hide R Chunks", "R", null, 32, null, false), handlers.get(".FilterRChunks")));
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        super.contextMenuAboutToShow(m);
        IPageSite site = this.getSite();
        if (m.find("stat.submit") == null) {
            m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        }
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitSelectionToR", null, null, null, null, null, "R", null, 8, null, false)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)site, null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", null, null, null, null, null, "U", null, 8, null, false)));
        m.add((IContributionItem)new Separator("more"));
    }

    protected IWikidocModelInfo getCurrentInputModel() {
        TreeViewer viewer = this.getViewer();
        if (viewer == null) {
            return null;
        }
        return (IWikidocModelInfo)this.getModelInfo(viewer.getInput());
    }

    private class ContentFilter
    implements IModelElement.Filter {
        private boolean hideRChunks;

        private ContentFilter() {
        }

        public boolean include(IModelElement element) {
            switch (element.getElementType() & 0xF00) {
                case 2048: {
                    if (!WikidocRweaveOutlinePage.isRChunk(element)) break;
                    return !this.hideRChunks;
                }
            }
            return true;
        }
    }

    public class ExpandElementsContributionItem
    extends HandlerContributionItem {
        private final IHandler2 expandElementsHandler;

        public ExpandElementsContributionItem(IServiceLocator serviceLocator, HandlerCollection handlers) {
            super(new CommandContributionItemParameter(serviceLocator, ".ExpandElements", "org.eclipse.ui.navigate.expandAll", null, null, null, null, "Expand All", "E", null, 4, null, false), handlers.get("org.eclipse.ui.navigate.expandAll"));
            this.expandElementsHandler = handlers.get(WikidocRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID);
        }

        protected void initDropDownMenu(final MenuManager menuManager) {
            menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                public void menuAboutToShow(IMenuManager manager) {
                    TreeViewer viewer = WikidocRweaveOutlinePage.this.getViewer();
                    if (viewer == null) {
                        return;
                    }
                    IWikidocModelInfo modelInfo = WikidocRweaveOutlinePage.this.getCurrentInputModel();
                    DocmlBaseUIResources baseResources = DocmlBaseUIResources.INSTANCE;
                    RedocsRUIResources redocsResources = RedocsRUIResources.INSTANCE;
                    if (modelInfo.getMinSectionLevel() > 0) {
                        if (modelInfo.getMinSectionLevel() < 2 && modelInfo.getMaxSectionLevel() >= 2) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)WikidocRweaveOutlinePage.this.getSite(), null, WikidocRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, H2_PARAMETERS, baseResources.getImageDescriptor("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H2"), null, null, "Show all H2 sections", "C", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                        }
                        if (modelInfo.getMinSectionLevel() < 3 && modelInfo.getMaxSectionLevel() >= 3) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)WikidocRweaveOutlinePage.this.getSite(), null, WikidocRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, H3_PARAMETERS, baseResources.getImageDescriptor("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H3"), null, null, "Show all H3 sections", "S", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                        }
                        if (modelInfo.getMinSectionLevel() < 4 && modelInfo.getMaxSectionLevel() >= 4) {
                            manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)WikidocRweaveOutlinePage.this.getSite(), null, WikidocRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, H4_PARAMETERS, baseResources.getImageDescriptor("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H4"), null, null, "Show all H4 sections", "u", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                            manager.add((IContributionItem)new Separator());
                        }
                    }
                    if (!WikidocRweaveOutlinePage.this.filter.hideRChunks) {
                        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)WikidocRweaveOutlinePage.this.getSite(), null, WikidocRweaveOutlinePage.EXPAND_ELEMENTS_COMMAND_ID, RCHUNK_PARAMETERS, redocsResources.getImageDescriptor("org.eclipse.statet.redocs.r/image/obj/rchunk"), null, null, "Show all R Chunks", "R", null, 8, null, false), ExpandElementsContributionItem.this.expandElementsHandler));
                    }
                }

                public void menuAboutToHide(IMenuManager manager) {
                    ExpandElementsContributionItem.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            menuManager.dispose();
                        }
                    });
                }
            });
        }
    }

    public class ExpandElementsHandler
    extends AbstractHandler {
        public Object execute(ExecutionEvent event) {
            final TreeViewer viewer = WikidocRweaveOutlinePage.this.getViewer();
            String type = event.getParameter("type");
            if (UIAccess.isOkToUse((Viewer)viewer) && type != null) {
                Object expandFilter;
                ISourceUnitModelInfo modelInfo = WikidocRweaveOutlinePage.this.getModelInfo(viewer.getInput());
                if (modelInfo == null) {
                    return null;
                }
                final IModelElement.Filter contentFilter = WikidocRweaveOutlinePage.this.getContentFilter();
                if (type.equals("rchunks")) {
                    expandFilter = new IModelElement.Filter(){

                        public boolean include(IModelElement element) {
                            if (contentFilter.include(element)) {
                                if ((element.getElementType() & 0xF00) == 2048 && WikidocRweaveOutlinePage.isRChunk(element)) {
                                    ViewerUtils.expandToLevel((AbstractTreeViewer)viewer, (Object)element, (int)0);
                                    return false;
                                }
                                ((ISourceStructElement)element).hasSourceChildren((IModelElement.Filter)this);
                                return false;
                            }
                            return false;
                        }
                    };
                } else {
                    final int sectionLevel = type.equals("h2") ? 2 : (type.equals("h3") ? 3 : (type.equals("h4") ? 4 : (type.equals("h5") ? 5 : (type.equals("h6") ? 6 : 0))));
                    if (sectionLevel < 1 || sectionLevel > 6) {
                        return null;
                    }
                    expandFilter = new IModelElement.Filter(){
                        private boolean childExpand;

                        public boolean include(IModelElement element) {
                            if (contentFilter.include(element) && (element.getElementType() & 0xFF0) == 1056) {
                                int currentLevel = element.getElementType() & 0xF;
                                if (currentLevel < 1 || currentLevel > sectionLevel) {
                                    return false;
                                }
                                if (currentLevel < sectionLevel) {
                                    this.childExpand = false;
                                    ((ISourceStructElement)element).hasSourceChildren((IModelElement.Filter)this);
                                    if (this.childExpand) {
                                        return false;
                                    }
                                }
                                ViewerUtils.expandToLevel((AbstractTreeViewer)viewer, (Object)element, (int)0);
                                this.childExpand = true;
                                return false;
                            }
                            return false;
                        }
                    };
                }
                modelInfo.getSourceElement().hasSourceChildren(expandFilter);
            }
            return null;
        }
    }

    private class FilterRChunks
    extends AbstractEditorOutlinePage.AbstractToggleHandler {
        public FilterRChunks() {
            super((AbstractEditorOutlinePage)WikidocRweaveOutlinePage.this, "filter.r_chunks.enabled", false, null, 0);
        }

        protected void apply(boolean on) {
            TreeViewer viewer = WikidocRweaveOutlinePage.this.getViewer();
            WikidocRweaveOutlinePage.this.filter.hideRChunks = on;
            if (UIAccess.isOkToUse((Viewer)viewer)) {
                viewer.refresh(false);
            }
        }
    }
}

