/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.server;

import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Authentication;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.FutureResponseListener;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.statet.internal.rhelp.core.server.NotFoundException;
import org.eclipse.statet.internal.rhelp.core.server.ResponseException;
import org.eclipse.statet.internal.rhelp.core.server.ServerREnvHelpAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class JettyREnvHelpAccess
extends ServerREnvHelpAccess {
    private final HttpClient httpClient;

    public JettyREnvHelpAccess(URI url, HttpClient httpClient) throws Exception {
        super(url);
        this.httpClient = httpClient;
        String userInfo = url.getUserInfo();
        if (userInfo != null) {
            String[] auth = userInfo.split("\\:", 2);
            this.httpClient.getAuthenticationStore().addAuthenticationResult((Authentication.Result)new BasicAuthentication.BasicResult(this.createUrl(this.getBasePath()), auth[0], auth.length == 2 ? auth[1] : ""));
        }
        this.httpClient.start();
    }

    protected void checkDataStreamResponse(Response response) throws ResponseException {
        if (response.getStatus() != 200) {
            String message = String.format("Http Status %1$s - %2$s", response.getStatus(), response.getReason());
            switch (response.getStatus()) {
                case 404: {
                    throw new NotFoundException(message);
                }
            }
            throw new ResponseException(message);
        }
        String contentType = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        if (contentType == null || !contentType.startsWith("application/x.org.eclipse.statet.rhelp-ds")) {
            throw new ResponseException(String.format("Unexpected content type: '%1$s'.", contentType));
        }
    }

    @Override
    protected @Nullable InputStream getDataStream(URI url, @Nullable String eTag) throws StatusException, ResponseException {
        Request request = this.httpClient.newRequest(url);
        if (eTag != null) {
            request.header(HttpHeader.IF_NONE_MATCH, eTag);
        }
        request.accept(new String[]{DS_VERSIONED_ACCEPT_HEADER});
        return this.doGetDataStream(request, eTag != null);
    }

    @Override
    protected InputStream getDataStream(URI url, String[] params, byte[] requestData) throws StatusException, ResponseException {
        Request request = this.httpClient.newRequest(url);
        int i = 0;
        while (i < params.length) {
            request.param(params[i++], params[i++]);
        }
        request.method(HttpMethod.POST);
        request.content((ContentProvider)new BytesContentProvider("application/x.org.eclipse.statet.rhelp-ds", (byte[][])new byte[][]{requestData}));
        request.accept(new String[]{"application/x.org.eclipse.statet.rhelp-ds"});
        return this.doGetDataStream(request, false);
    }

    private @Nullable InputStream doGetDataStream(Request request, boolean notModified) throws StatusException, ResponseException {
        Response response;
        InputStreamResponseListener listener;
        block7: {
            listener = new InputStreamResponseListener();
            request.send((Response.CompleteListener)listener);
            response = listener.get(20L, TimeUnit.SECONDS);
            if (!notModified || response.getStatus() != 304) break block7;
            return null;
        }
        try {
            this.checkDataStreamResponse(response);
            return listener.getInputStream();
        }
        catch (InterruptedException | CancellationException e) {
            request.abort((Throwable)e);
            throw this.onCancelled();
        }
        catch (TimeoutException e) {
            request.abort((Throwable)e);
            throw this.onTimeout(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TimeoutException) {
                request.abort(e.getCause());
                throw this.onTimeout(e.getCause());
            }
            if (e.getCause() instanceof ConnectException) {
                request.abort(e.getCause());
                throw this.onConnectError(e.getCause());
            }
            request.abort((Throwable)e);
            throw this.onFailed(e);
        }
    }

    @Override
    protected byte[] getDataStreamBytes(URI url, String[] params, int timeout, @Nullable ProgressMonitor m) throws StatusException, ResponseException {
        Request request = this.httpClient.newRequest(url);
        int i = 0;
        while (i < params.length) {
            request.param(params[i++], params[i++]);
        }
        request.accept(new String[]{"application/x.org.eclipse.statet.rhelp-ds"});
        if (timeout != -1) {
            request.timeout((long)timeout, TimeUnit.SECONDS);
        }
        FutureResponseListener listener = new FutureResponseListener(request);
        request.send((Response.CompleteListener)listener);
        while (true) {
            try {
                ContentResponse response = m != null ? listener.get(100L, TimeUnit.MILLISECONDS) : listener.get();
                this.checkDataStreamResponse((Response)response);
                return response.getContent();
            }
            catch (TimeoutException e) {
                if (!m.isCanceled()) continue;
                listener.cancel(true);
                throw this.onCancelled();
            }
            catch (InterruptedException | CancellationException e) {
                request.abort((Throwable)e);
                if (m != null) {
                    m.setCanceled(true);
                }
                throw this.onCancelled();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof TimeoutException) {
                    request.abort(e.getCause());
                    throw this.onTimeout(e.getCause());
                }
                if (e.getCause() instanceof ConnectException) {
                    request.abort(e.getCause());
                    throw this.onConnectError(e.getCause());
                }
                request.abort((Throwable)e);
                throw this.onFailed(e);
            }
            break;
        }
    }
}

