/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.jcommons.text.core.input.StringParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.model.RGraphicFunctions;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.statet.r.ui.graphics.RFontFamilyChooser;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprWidget;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.statushandlers.StatusManager;

public class FontFamilyType
extends RExprWidget.TypeDef
implements PaintListener,
Listener {
    private Button detail;
    private String currentValue;
    private String currentFontName;
    private Font currentSWTFont;
    private RFontFamilyChooser fontChooser;
    private final RGraphicFunctions rGraphicFunctions = RGraphicFunctions.DEFAULT;

    public FontFamilyType(RExprTypeUIAdapter type) {
        super(type);
    }

    @Override
    public boolean hasDetail() {
        return true;
    }

    @Override
    protected Control createDetailControl(Composite parent) {
        this.detail = new Button(parent, 0);
        this.detail.addPaintListener((PaintListener)this);
        this.detail.addListener(13, (Listener)this);
        this.detail.addListener(12, (Listener)this);
        return this.detail;
    }

    @Override
    public void valueAboutToChange(ObjValueEvent<RTypedExpr> event) {
        RTypedExpr newExpr = (RTypedExpr)event.newValue;
        String newValue = null;
        try {
            if (newExpr != null && newExpr.getTypeKey() == "r") {
                RScanner scanner = new RScanner(4);
                newValue = this.rGraphicFunctions.parseFontFamily(scanner.scanExpr((TextParserInput)new StringParserInput(newExpr.getExpr()).init()));
            }
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.rtm.base.ui", "An error occurred when parsing the R font family value expression.", (Throwable)e));
        }
        this.doSetValue(newValue);
        this.detail.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc = e.gc;
        Point size = this.detail.getSize();
        gc.setForeground(gc.getDevice().getSystemColor(16));
        gc.drawRectangle(4, 4, size.x - 9, size.y - 9);
        if (this.currentFontName != null && !this.currentFontName.isEmpty()) {
            if (this.currentSWTFont == null) {
                this.currentSWTFont = RFontFamilyChooser.createFont((Device)this.detail.getDisplay(), (String)this.currentFontName, (int)this.detail.getFont().getFontData()[0].getHeight());
                if (this.currentSWTFont == null) {
                    this.currentFontName = "";
                }
            }
            RFontFamilyChooser.drawPreview((GC)gc, (int)5, (int)5, (int)(size.x - 11), (int)(size.y - 11), (Font)this.currentSWTFont);
        }
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                this.showColorChooser();
                return;
            }
            case 12: {
                if (this.fontChooser != null) {
                    this.fontChooser.dispose();
                }
                if (this.currentSWTFont != null) {
                    this.currentSWTFont.dispose();
                    this.currentSWTFont = null;
                }
                return;
            }
        }
    }

    private void showColorChooser() {
        if (this.fontChooser == null) {
            this.fontChooser = new RFontFamilyChooser(){

                protected void onOK() {
                    FontFamilyType.this.setValue(this.getValue());
                }
            };
        }
        if (this.fontChooser.isActive()) {
            this.fontChooser.close();
            return;
        }
        Rectangle bounds = this.detail.getBounds();
        Point location = this.detail.getParent().toDisplay(new Point(bounds.x, bounds.y));
        bounds.x = location.x;
        bounds.y = location.y;
        this.fontChooser.open(this.detail.getShell(), bounds, this.currentValue);
    }

    private void setValue(String value) {
        if (value == null) {
            this.setExpr("");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        sb.append(value);
        sb.append('\"');
        this.doSetValue(value);
        this.detail.redraw();
        this.setExpr(sb.toString());
    }

    private void doSetValue(String value) {
        String fontName = RFontFamilyChooser.getFontName((String)value);
        if (this.currentSWTFont != null && !this.currentFontName.equals(fontName)) {
            this.currentSWTFont.dispose();
            this.currentSWTFont = null;
        }
        this.currentValue = value;
        this.currentFontName = fontName;
    }
}

