/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.dbg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.statet.jcommons.collections.CollectionUtils;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.server.dbg.Srcref;
import org.eclipse.statet.rj.server.dbg.Tracepoint;
import org.eclipse.statet.rj.server.dbg.TracepointPosition;

@NonNullByDefault
public final class Tracepoints {
    public static final Logger LOGGER = Logger.getLogger("org.eclipse.statet.rj.server.dbg");
    public static final String TOPLEVEL_ELEMENT_ID = "200:";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final int indexOfTracepointById(List<? extends Tracepoint> entries, long id) {
        int idx = 0;
        while (idx < entries.size()) {
            if (entries.get(idx).getId() == id) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public static final @Nullable TracepointPosition getPositionById(List<? extends TracepointPosition> list, long id) {
        int j = 0;
        while (j < list.size()) {
            TracepointPosition p = list.get(j);
            if (p.getId() == id) {
                return p;
            }
            ++j;
        }
        return null;
    }

    public static final boolean containsPositionsById(List<? extends TracepointPosition> list, List<? extends TracepointPosition> requiredIds) {
        if (list == requiredIds) {
            return true;
        }
        int l = requiredIds.size();
        if (list.size() < l) {
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < l) {
            block5: {
                long id = requiredIds.get(i).getId();
                while (j < list.size()) {
                    if (list.get(j++).getId() != id) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final boolean equalsPositions(List<? extends TracepointPosition> list1, List<? extends TracepointPosition> list2, List<? extends TracepointPosition> requiredIds) {
        if (list1 == list2) {
            return true;
        }
        int l = list1.size();
        if (l != list2.size()) {
            return false;
        }
        int i = 0;
        int j1 = 0;
        int j2 = 0;
        while (i < l) {
            block6: {
                long id = requiredIds.get(i).getId();
                while (j1 < list1.size()) {
                    TracepointPosition p1;
                    if ((p1 = list1.get(j1++)).getId() != id) continue;
                    while (j2 < list2.size()) {
                        TracepointPosition p2;
                        if ((p2 = list1.get(j2++)).getId() != id) continue;
                        if (!p1.equals(p2)) {
                            return false;
                        }
                        break block6;
                    }
                    return false;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final List<TracepointPosition> filterPositionsByIdRequired(List<? extends TracepointPosition> list, List<? extends TracepointPosition> requiredIds) {
        int l = requiredIds.size();
        if (list.size() == l) {
            return ImCollections.toList(list);
        }
        Object[] array = new TracepointPosition[l];
        int i = 0;
        int j = 0;
        while (i < l) {
            TracepointPosition p;
            block3: {
                long id = requiredIds.get(i).getId();
                while (j < list.size()) {
                    if ((p = list.get(j++)).getId() != id) continue;
                    break block3;
                }
                throw new IllegalArgumentException("TracepointPosition missing: id= " + id);
            }
            array[i] = p;
            ++i;
        }
        return ImCollections.newList((Object[])array);
    }

    public static final List<TracepointPosition> filterPositionsById(List<? extends TracepointPosition> list, List<? extends TracepointPosition> includedIds) {
        int l = includedIds.size();
        ArrayList<TracepointPosition> intersection = new ArrayList<TracepointPosition>(l);
        int i = 0;
        int j = 0;
        while (i < l) {
            long id = includedIds.get(i).getId();
            int j0 = j;
            while (j0 < list.size()) {
                TracepointPosition p;
                if ((p = list.get(j0++)).getId() != id) continue;
                intersection.add(p);
                j = j0;
                break;
            }
            ++i;
        }
        return intersection;
    }

    public static final List<TracepointPosition> filterPositionsById(List<? extends TracepointPosition> list, long[] includedIds) {
        int l = includedIds.length;
        ArrayList<TracepointPosition> intersection = new ArrayList<TracepointPosition>(l);
        int i = 0;
        int j = 0;
        while (i < l) {
            long id = includedIds[i];
            int j0 = j;
            while (j0 < list.size()) {
                TracepointPosition p;
                if ((p = list.get(j0++)).getId() != id) continue;
                intersection.add(p);
                j = j0;
                break;
            }
            ++i;
        }
        return intersection;
    }

    public static final List<TracepointPosition> filterPositionsBySrcref(List<? extends TracepointPosition> list, int[] baseSrcref, int[] includedSrcref) {
        ArrayList<TracepointPosition> intersection = new ArrayList<TracepointPosition>(list.size());
        int j = 0;
        while (j < list.size()) {
            TracepointPosition p = list.get(j);
            int[] @Nullable [] srcrefs = p.getSrcrefs();
            int i = 0;
            while (i < srcrefs.length) {
                if (srcrefs[i] != null && Srcref.equalsStart(Srcref.add(srcrefs[i], baseSrcref), includedSrcref)) {
                    intersection.add(p);
                    break;
                }
                ++i;
            }
            ++j;
        }
        return intersection;
    }

    public static final int @Nullable [] findIndexBySrcref(List<? extends TracepointPosition> list, int[] baseSrcref, int[] includedSrcref) {
        int j = 0;
        while (j < list.size()) {
            TracepointPosition p = list.get(j);
            int[] @Nullable [] srcrefs = p.getSrcrefs();
            int depth = 0;
            while (depth < srcrefs.length) {
                if (srcrefs[depth] != null && Srcref.equalsStart(Srcref.add(srcrefs[depth], baseSrcref), includedSrcref)) {
                    return Arrays.copyOf(p.getIndex(), depth + 1);
                }
                ++depth;
            }
            ++j;
        }
        return null;
    }

    public static final int @Nullable [] findIndexByReference(List<? extends TracepointPosition> list, List<? extends TracepointPosition> reference) {
        if (!list.isEmpty()) {
            TracepointPosition p = list.get(0);
            TracepointPosition refP = (TracepointPosition)ObjectUtils.nonNullAssert((Object)Tracepoints.getPositionById(reference, p.getId()));
            int[] index = p.getIndex();
            int depth = index.length - 1 - refP.getIndex().length;
            if (depth > 0 && depth < index.length) {
                return Arrays.copyOf(index, depth + 1);
            }
        }
        return null;
    }

    private static final boolean equalsIndex(int[] index, int[] included) {
        if (index.length < included.length) {
            return false;
        }
        int i = 0;
        while (i < included.length) {
            if (index[i] != included[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static final int @Nullable [] getSrcrefForIndex(List<? extends TracepointPosition> list, int[] includedIndex) {
        int depth = includedIndex.length - 1;
        int j = 0;
        while (j < list.size()) {
            int[] srcref;
            TracepointPosition p = list.get(j);
            if (Tracepoints.equalsIndex(p.getIndex(), includedIndex) && (srcref = p.getSrcref(depth)) != null) {
                return srcref;
            }
            ++j;
        }
        return null;
    }

    public static final List<TracepointPosition> rebasePositionsByIndex(List<? extends TracepointPosition> list, int[] newBaseIndex) {
        int depth = newBaseIndex.length - 1;
        ArrayList<TracepointPosition> intersection = new ArrayList<TracepointPosition>(list.size());
        int j = 0;
        while (j < list.size()) {
            TracepointPosition p = list.get(j);
            int[] index = p.getIndex();
            if (Tracepoints.equalsIndex(index, newBaseIndex) && p.getSrcref() != null && p.getSrcref(depth) != null) {
                intersection.add(new TracepointPosition(p.getType(), p.getId(), Arrays.copyOfRange(index, depth + 1, index.length), Srcref.substract(p.getSrcref(), p.getSrcref(depth))));
            }
            ++j;
        }
        return intersection;
    }

    public static final String toString(long id) {
        char[] c = new char[16];
        int i = 0;
        while (i < 16) {
            c[15 - i] = DIGITS[(int)id & 0xF];
            id >>>= 4;
            ++i;
        }
        return new String(c, 0, 16);
    }

    public static final void append(long id, StringBuilder sb) {
        char[] c = new char[16];
        int i = 0;
        while (i < 16) {
            c[15 - i] = DIGITS[(int)id & 0xF];
            id >>>= 4;
            ++i;
        }
        sb.append(c);
    }

    public static final String toLogString(List<? extends TracepointPosition> positions) {
        int n = positions.size();
        if (n <= 0) {
            return "";
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            return "\n\t\t" + CollectionUtils.toString(positions, (String)"\n\t\t");
        }
        StringBuilder sb = new StringBuilder(n * 18);
        sb.append(positions.get(0).getId());
        int i = 1;
        while (i < n) {
            sb.append(", ");
            Tracepoints.append(positions.get(i).getId(), sb);
            ++i;
        }
        return sb.toString();
    }

    private Tracepoints() {
    }
}

