/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.IElementChangedListener;
import org.eclipse.statet.ltk.model.core.IModelManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public abstract class AbstractModelManager
implements IModelManager {
    private static final ImIdentityList<IElementChangedListener> NO_LISTENERS = ImCollections.emptyIdentityList();
    private final String typeId;
    private final CopyOnWriteIdentityListSet<ContextItem> contexts = new CopyOnWriteIdentityListSet();

    public AbstractModelManager(String typeId) {
        this.typeId = typeId;
    }

    public String getModelTypeId() {
        return this.typeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ContextItem getContextItem(WorkingContext context, boolean create) {
        while (true) {
            ImIdentityList contextItems = this.contexts.toList();
            for (ContextItem contextItem : contextItems) {
                if (contextItem.context != context) continue;
                return contextItem;
            }
            if (!create) {
                return null;
            }
            CopyOnWriteIdentityListSet<ContextItem> copyOnWriteIdentityListSet = this.contexts;
            synchronized (copyOnWriteIdentityListSet) {
                if (contextItems == this.contexts.toList()) {
                    ContextItem item = this.doCreateContextItem(context);
                    this.contexts.add((Object)item);
                    return item;
                }
            }
        }
    }

    protected ContextItem doCreateContextItem(WorkingContext context) {
        return new ContextItem(context);
    }

    @Override
    public void addElementChangedListener(IElementChangedListener listener, WorkingContext context) {
        ContextItem contextItem = this.getContextItem(context, true);
        contextItem.listeners.add((Object)listener);
    }

    @Override
    public void removeElementChangedListener(IElementChangedListener listener, WorkingContext context) {
        ContextItem contextItem = this.getContextItem(context, false);
        if (contextItem != null) {
            contextItem.listeners.remove((Object)listener);
        }
    }

    protected ImIdentityList<IElementChangedListener> getElementChangedListeners(WorkingContext context) {
        ContextItem contextItem = this.getContextItem(context, false);
        if (contextItem == null) {
            return NO_LISTENERS;
        }
        return contextItem.listeners.toList();
    }

    @Override
    public void refresh(WorkingContext context) {
        new RefreshJob(context, 0x2000003).schedule();
    }

    @Override
    public void registerDependentUnit(ISourceUnit su) {
    }

    @Override
    public void deregisterDependentUnit(ISourceUnit su) {
    }

    protected static class ContextItem {
        public final WorkingContext context;
        public final CopyOnWriteIdentityListSet<IElementChangedListener> listeners = new CopyOnWriteIdentityListSet();

        protected ContextItem(WorkingContext context) {
            this.context = context;
        }

        public final int hashCode() {
            return this.context.hashCode();
        }

        public final boolean equals(Object obj) {
            return this == obj;
        }
    }

    private class RefreshJob
    extends Job {
        private final List<ISourceUnit> list;
        private final int flags;

        public RefreshJob(WorkingContext context, int flags) {
            super("Model Refresh");
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(50);
            this.list = LTK.getSourceUnitManager().getOpenSourceUnits(AbstractModelManager.this.typeId, context);
            this.flags = flags;
        }

        protected IStatus run(IProgressMonitor monitor) {
            for (ISourceUnit su : this.list) {
                su.getModelInfo(null, this.flags, monitor);
            }
            return Status.OK_STATUS;
        }
    }
}

