/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui.sourceediting;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.yaml.core.YamlCodeStyleSettings;
import org.eclipse.statet.yaml.core.YamlCore;
import org.eclipse.statet.yaml.core.YamlCoreAccess;
import org.eclipse.statet.yaml.core.source.YamlDocumentSetupParticipant;
import org.eclipse.statet.yaml.ui.sourceediting.YamlSourceViewerConfiguration;

public class YamlSourceViewerConfigurator
extends SourceEditorViewerConfigurator
implements YamlCoreAccess,
PropertyChangeListener {
    private static final Set<String> RESET_GROUP_IDS = new HashSet<String>(Arrays.asList("org.eclipse.statet.yaml.core/codestyle/Yaml/indent"));
    private YamlCoreAccess sourceCoreAccess;
    private final YamlCodeStyleSettings yamlCodeStyleCopy = new YamlCodeStyleSettings(1);

    public YamlSourceViewerConfigurator(YamlCoreAccess coreAccess, YamlSourceViewerConfiguration config) {
        super((SourceEditorViewerConfiguration)config);
        config.setCoreAccess(this);
        this.setSource(coreAccess);
        this.yamlCodeStyleCopy.load(this.sourceCoreAccess.getYamlCodeStyle());
        this.yamlCodeStyleCopy.resetDirty();
        this.yamlCodeStyleCopy.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public IDocumentSetupParticipant getDocumentSetupParticipant() {
        return new YamlDocumentSetupParticipant();
    }

    protected Set<String> getResetGroupIds() {
        return RESET_GROUP_IDS;
    }

    public void setSource(YamlCoreAccess newAccess) {
        if (newAccess == null) {
            newAccess = YamlCore.getWorkbenchAccess();
        }
        if (this.sourceCoreAccess != newAccess) {
            this.sourceCoreAccess = newAccess;
            this.handleSettingsChanged(null, null);
        }
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        this.yamlCodeStyleCopy.resetDirty();
    }

    protected void checkSettingsChanges(Set<String> groupIds, Map<String, Object> options) {
        super.checkSettingsChanges(groupIds, options);
        if (groupIds.contains("org.eclipse.statet.yaml.core/codestyle/Yaml/indent")) {
            this.yamlCodeStyleCopy.load(this.sourceCoreAccess.getYamlCodeStyle());
        }
        if (groupIds.contains("org.eclipse.statet.yaml.ui/editor/editing")) {
            this.updateCompleteConfig = true;
        }
    }

    public PreferenceAccess getPrefs() {
        return this.sourceCoreAccess.getPrefs();
    }

    public YamlCodeStyleSettings getYamlCodeStyle() {
        return this.yamlCodeStyleCopy;
    }
}

