/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.ui;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class ActivatedContentTypeTester
extends PropertyTester {
    public static final String MATCH_ACTIVATED_TYPE = "matchesActivatedContentType";
    public static final String MATCH_TYPE = "matchesContentType";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        String expectedContentTypeId;
        Object editorInput;
        IResource resource;
        IAdaptable adaptableReceiver;
        if (!(expectedValue instanceof String)) {
            return false;
        }
        IContentType contentType = null;
        IFile file = null;
        if (receiver instanceof IFile) {
            file = (IFile)receiver;
        } else if (receiver instanceof IAdaptable && (file = (IFile)(adaptableReceiver = (IAdaptable)receiver).getAdapter(IFile.class)) == null && (resource = (IResource)adaptableReceiver.getAdapter(IResource.class)) instanceof IFile) {
            file = (IFile)resource;
        }
        if (file == null && (editorInput = receiver instanceof IEditorInput ? (IEditorInput)receiver : (receiver instanceof IEditorPart ? ((IEditorPart)receiver).getEditorInput() : null)) != null) {
            file = (IFile)editorInput.getAdapter(IFile.class);
        }
        if (file != null) {
            try {
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription != null) {
                    contentType = contentDescription.getContentType();
                }
            }
            catch (CoreException contentDescription) {}
        } else if (receiver instanceof IAdaptable) {
            contentType = (IContentType)((IAdaptable)receiver).getAdapter(IContentType.class);
        }
        if (property.equals(MATCH_ACTIVATED_TYPE)) {
            expectedContentTypeId = (String)expectedValue;
            if (contentType != null) {
                return LTK.getExtContentTypeManager().matchesActivatedContentType(contentType.getId(), expectedContentTypeId, true);
            }
            return false;
        }
        if (property.equals(MATCH_TYPE)) {
            expectedContentTypeId = (String)expectedValue;
            while (contentType != null) {
                if (expectedContentTypeId.equals(contentType.getId())) {
                    return true;
                }
                contentType = contentType.getBaseType();
            }
            return false;
        }
        return false;
    }
}

