/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.core.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.docmlet.tex.core.commands.EnvDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.LtxCommandDefinitions;
import org.eclipse.statet.docmlet.tex.core.commands.TexCommand;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TexCommandSet {
    public static final String LTX_TEXT_CONTEXT_ID = "ltx:text";
    public static final String LTX_PREAMBLE_CONTEXT_ID = "ltx:preamble";
    public static final String LTX_MATH_CONTEXT_ID = "ltx:math";
    public static final String QUALIFIER = "org.eclipse.statet.docmlet.tex.core/tex.commands";
    public static final Preference<Set<String>> MASTER_COMMANDS_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.CommandsMaster.include");
    public static final Preference<Set<String>> PREAMBLE_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.PreambleCommands.include");
    public static final Preference<Set<String>> TEXT_COMMANDS_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.TextCommands.include");
    public static final Preference<Set<String>> MATH_COMMANDS_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.MathCommands.include");
    public static final Preference<Set<String>> TEXT_ENVS_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.TextEnvs.include");
    public static final Preference<Set<String>> MATH_ENVS_INCLUDE_PREF = new Preference.StringSetPref("org.eclipse.statet.docmlet.tex.core/tex.commands", "LtxCommands.MathEnvs.include");
    private static final Map<String, TexCommand> LTX_INTERN_ENVS = new IdentityHashMap<String, TexCommand>();
    private final List<TexCommand> allCommands;
    private final List<TexCommand> allEnvs;
    private final ContextSet ltxText;
    private final ContextSet ltxPreamble;
    private final ContextSet ltxMath;
    private final Map<String, TexCommand> internEnvMap;

    static {
        LtxCommandDefinitions.add(LTX_INTERN_ENVS, EnvDefinitions.ENV_Sinput_BEGIN);
        LtxCommandDefinitions.add(LTX_INTERN_ENVS, EnvDefinitions.ENV_Souput_BEGIN);
    }

    public TexCommandSet(PreferenceAccess prefs) {
        Set master = (Set)prefs.getPreferenceValue(MASTER_COMMANDS_INCLUDE_PREF);
        ArrayList<TexCommand> filteredCommands = new ArrayList<TexCommand>(master.size());
        List<TexCommand> commonCommands = LtxCommandDefinitions.getAllCommands();
        int i = 0;
        while (i < commonCommands.size()) {
            TexCommand command = commonCommands.get(i);
            if (master.contains(command.getControlWord())) {
                filteredCommands.add(command);
            }
            ++i;
        }
        this.allCommands = ImCollections.toList(filteredCommands);
        Object[] array = this.allCommands.toArray(new TexCommand[this.allCommands.size()]);
        Arrays.sort(array);
        ImList sortedCommands = ImCollections.newList((Object[])array);
        ImList<TexCommand> commonEnvs = LtxCommandDefinitions.getAllEnvs();
        this.allEnvs = ImCollections.toList(commonEnvs);
        Object[] array2 = this.allEnvs.toArray(new TexCommand[this.allEnvs.size()]);
        Arrays.sort(array2);
        ImList sortedEnvs = ImCollections.newList((Object[])array2);
        this.ltxText = new ContextSet(LTX_TEXT_CONTEXT_ID, (List<TexCommand>)sortedCommands, (Set)prefs.getPreferenceValue(TEXT_COMMANDS_INCLUDE_PREF), (List<TexCommand>)sortedEnvs, (Set)prefs.getPreferenceValue(TEXT_ENVS_INCLUDE_PREF));
        this.ltxPreamble = new ContextSet(LTX_PREAMBLE_CONTEXT_ID, (List<TexCommand>)sortedCommands, (Set)prefs.getPreferenceValue(PREAMBLE_INCLUDE_PREF), null, null);
        this.ltxMath = new ContextSet(LTX_MATH_CONTEXT_ID, (List<TexCommand>)sortedCommands, (Set)prefs.getPreferenceValue(MATH_COMMANDS_INCLUDE_PREF), (List<TexCommand>)sortedEnvs, (Set)prefs.getPreferenceValue(MATH_ENVS_INCLUDE_PREF));
        this.internEnvMap = LTX_INTERN_ENVS;
    }

    public TexCommandSet(List<TexCommand> allCommands, List<TexCommand> allEnvs, Map<String, TexCommand> textCommandMap, List<TexCommand> textCommandList, Map<String, TexCommand> textEnvMap, List<TexCommand> textEnvList, Map<String, TexCommand> preambleCommandMap, List<TexCommand> preambleCommandList, Map<String, TexCommand> mathCommandMap, List<TexCommand> mathCommandList, Map<String, TexCommand> mathEnvMap, List<TexCommand> mathEnvList, Map<String, TexCommand> internEnvMap) {
        this.allCommands = allCommands;
        this.allEnvs = allEnvs;
        this.ltxText = new ContextSet(LTX_TEXT_CONTEXT_ID, textCommandMap, textCommandList, textEnvMap, textEnvList);
        this.ltxPreamble = new ContextSet(LTX_PREAMBLE_CONTEXT_ID, preambleCommandMap, preambleCommandList, null, null);
        this.ltxMath = new ContextSet(LTX_MATH_CONTEXT_ID, mathCommandMap, mathCommandList, mathEnvMap, mathEnvList);
        this.internEnvMap = internEnvMap;
    }

    public List<TexCommand> getAllLtxCommands() {
        return this.allCommands;
    }

    public List<TexCommand> getAllLtxEnvs() {
        return this.allEnvs;
    }

    public Map<String, TexCommand> getLtxTextCommandMap() {
        return this.ltxText.commandMap;
    }

    public List<TexCommand> getLtxTextCommandsASorted() {
        return this.ltxText.commandListASorted;
    }

    public Map<String, TexCommand> getLtxTextEnvMap() {
        return this.ltxText.envMap;
    }

    public List<TexCommand> getLtxTextEnvsASorted() {
        return this.ltxText.envListASorted;
    }

    public Map<String, TexCommand> getLtxPreambleCommandMap() {
        return this.ltxPreamble.commandMap;
    }

    public List<TexCommand> getLtxPreambleCommandsASorted() {
        return this.ltxPreamble.commandListASorted;
    }

    public Map<String, TexCommand> getLtxMathCommandMap() {
        return this.ltxMath.commandMap;
    }

    public List<TexCommand> getLtxMathCommandsASorted() {
        return this.ltxMath.commandListASorted;
    }

    public Map<String, TexCommand> getLtxMathEnvMap() {
        return this.ltxMath.envMap;
    }

    public List<TexCommand> getLtxMathEnvsASorted() {
        return this.ltxMath.envListASorted;
    }

    private @Nullable ContextSet getContextSet(String contextId) {
        if (contextId == LTX_TEXT_CONTEXT_ID) {
            return this.ltxText;
        }
        if (contextId == LTX_PREAMBLE_CONTEXT_ID) {
            return this.ltxPreamble;
        }
        if (contextId == LTX_MATH_CONTEXT_ID) {
            return this.ltxMath;
        }
        return null;
    }

    public @Nullable List<TexCommand> getCommandsASorted(String contextId) {
        ContextSet contextSet = this.getContextSet(contextId);
        if (contextSet != null) {
            return contextSet.commandListASorted;
        }
        return null;
    }

    public @Nullable List<TexCommand> getEnvsASorted(String contextId) {
        ContextSet contextSet = this.getContextSet(contextId);
        if (contextSet != null) {
            return contextSet.commandListASorted;
        }
        return null;
    }

    public Map<String, TexCommand> getLtxInternEnvMap() {
        return this.internEnvMap;
    }

    private static final class ContextSet {
        private final String contextId;
        private final @Nullable Map<String, TexCommand> commandMap;
        private final @Nullable ImList<TexCommand> commandListASorted;
        private final @Nullable Map<String, TexCommand> envMap;
        private final @Nullable ImList<TexCommand> envListASorted;

        public ContextSet(String contextId, Map<String, TexCommand> commandMap, List<TexCommand> commandListASorted, Map<String, TexCommand> envMap, List<TexCommand> envListASorted) {
            this.contextId = contextId;
            this.commandMap = commandMap;
            this.commandListASorted = commandListASorted != null ? ImCollections.toList(commandListASorted) : null;
            this.envMap = envMap;
            this.envListASorted = envListASorted != null ? ImCollections.toList(envListASorted) : null;
        }

        public ContextSet(String contextId, @Nullable List<TexCommand> commandDefs, @Nullable Set<String> commandFilter, @Nullable List<TexCommand> envDefs, @Nullable Set<String> envFilter) {
            Object[] array;
            IdentityHashMap<String, TexCommand> map;
            ArrayList<TexCommand> list;
            this.contextId = contextId;
            if (commandDefs != null) {
                list = new ArrayList<TexCommand>(commandFilter.size() + 16);
                map = new IdentityHashMap<String, TexCommand>(commandFilter.size());
                for (TexCommand command : commandDefs) {
                    if (!commandFilter.contains(command.getControlWord())) continue;
                    map.put(command.getControlWord(), command);
                    list.add(command);
                }
                array = list.toArray(new TexCommand[list.size()]);
                Arrays.sort(array);
                this.commandMap = map;
                this.commandListASorted = ImCollections.newList((Object[])array);
            } else {
                this.commandMap = null;
                this.commandListASorted = null;
            }
            if (envDefs != null) {
                list = new ArrayList(envFilter.size() + 16);
                map = new IdentityHashMap(envFilter.size());
                for (TexCommand command : envDefs) {
                    if (!envFilter.contains(command.getControlWord())) continue;
                    map.put(command.getControlWord(), command);
                    list.add(command);
                }
                array = list.toArray(new TexCommand[list.size()]);
                Arrays.sort(array);
                this.envMap = map;
                this.envListASorted = ImCollections.newList((Object[])array);
            } else {
                this.envMap = null;
                this.envListASorted = null;
            }
        }
    }
}

