/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.eval;

import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.statet.ecommons.debug.core.eval.EvaluationWatchExpressionResult;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationListener;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationResult;
import org.eclipse.statet.internal.r.debug.core.model.RStackFrame;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.debug.core.IRThread;

@NonNullByDefault
public class RWatchExpressionDelegate
implements IWatchExpressionDelegate,
IEvaluationListener {
    private IWatchExpressionListener listener;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        RStackFrame frame;
        boolean force = false;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int end = Math.min(stackTrace.length, 8);
        int i = 2;
        while (i < end) {
            String className = stackTrace[i].getClassName();
            if (className.equals("org.eclipse.debug.internal.ui.viewers.update.DefaultWatchExpressionModelProxy")) break;
            if (className.equals("org.eclipse.debug.internal.ui.actions.expressions.ReevaluateWatchExpressionAction")) {
                force = true;
            }
            ++i;
        }
        if ((frame = this.checkContext(context)) == null) {
            listener.watchEvaluationFinished(null);
            return;
        }
        this.listener = listener;
        frame.getThread().evaluate(expression, frame, force, this);
    }

    private @Nullable RStackFrame checkContext(IDebugElement context) {
        IRStackFrame frame = null;
        if (context instanceof IRStackFrame) {
            frame = (IRStackFrame)context;
        } else if (context instanceof IRThread) {
            frame = ((IRThread)context).getTopStackFrame();
        }
        if (frame == null) {
            return null;
        }
        return (RStackFrame)frame;
    }

    public void evaluationFinished(IEvaluationResult result) {
        if (result.getStatus() < 24) {
            this.listener.watchEvaluationFinished((IWatchExpressionResult)new EvaluationWatchExpressionResult(result));
        } else {
            result.free();
        }
    }
}

