/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.WikidocSuModelContainer;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextSourceUnit;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikidocReconciler;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.model.core.IModelElementDelta;
import org.eclipse.statet.ltk.model.core.IModelManager;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelEventJob;
import org.eclipse.statet.ltk.model.core.impl.AbstractModelManager;
import org.eclipse.statet.ltk.model.core.impl.SourceUnitModelContainer;

public class WikitextModelManager
extends AbstractModelManager
implements IModelManager,
Disposable {
    private final EventJob eventJob = new EventJob(this);
    private final WikidocReconciler reconciler = new WikidocReconciler(this);

    public WikitextModelManager() {
        super("Wikidoc");
    }

    public void dispose() {
        this.eventJob.dispose();
    }

    public EventJob getEventJob() {
        return this.eventJob;
    }

    public void reconcile(SourceUnitModelContainer<?, ?> adapter, int level, IProgressMonitor monitor) {
        if (adapter instanceof WikidocSuModelContainer) {
            this.reconciler.reconcile((WikidocSuModelContainer)adapter, level, monitor);
        }
    }

    protected static class EventJob
    extends AbstractModelEventJob<WikitextSourceUnit, IWikidocModelInfo> {
        public EventJob(WikitextModelManager manager) {
            super((AbstractModelManager)manager);
        }

        protected IModelElementDelta createDelta(AbstractModelEventJob.Task task) {
            return new ModelDelta(task.getElement(), task.getOldInfo(), task.getNewInfo());
        }

        protected void dispose() {
            super.dispose();
        }
    }

    private static class ModelDelta
    implements IModelElementDelta {
        private final int level;
        private final IModelElement element;
        private final ISourceUnitModelInfo oldInfo;
        private final AstInfo oldAst;
        private final ISourceUnitModelInfo newInfo;
        private final AstInfo newAst;

        public ModelDelta(IModelElement element, ISourceUnitModelInfo oldInfo, ISourceUnitModelInfo newInfo) {
            this.level = 2;
            this.element = element;
            this.oldInfo = oldInfo;
            this.oldAst = oldInfo != null ? oldInfo.getAst() : null;
            this.newInfo = newInfo;
            this.newAst = newInfo != null ? newInfo.getAst() : null;
        }

        public IModelElement getModelElement() {
            return this.element;
        }

        public AstInfo getOldAst() {
            return this.oldAst;
        }

        public AstInfo getNewAst() {
            return this.newAst;
        }
    }
}

