/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.eutils.autonature.core.ProjectConfigurator;
import org.eclipse.statet.internal.eutils.autonature.Task;

public class ConfiguratorTask
extends Task {
    private final String label;
    private final String natureId;
    private IConfigurationElement configElement;
    private ProjectConfigurator configurator;

    public ConfiguratorTask(String label, String natureId, IConfigurationElement configElement) {
        this.label = label;
        this.natureId = natureId;
        this.configElement = configElement;
    }

    private synchronized ProjectConfigurator getProjectConfigurator() throws CoreException {
        if (this.configElement != null) {
            try {
                this.configurator = (ProjectConfigurator)this.configElement.createExecutableExtension("class");
            }
            finally {
                this.configElement = null;
            }
        }
        return this.configurator;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public boolean isAvailable() {
        return this.label != null;
    }

    @Override
    public boolean isSupported(byte mode) {
        return mode == 2;
    }

    @Override
    public byte check(IProject project, int flags, SubMonitor m) throws CoreException {
        if (this.natureId != null) {
            try {
                if (project.hasNature(this.natureId)) {
                    return 1;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((flags & 1) == 0) {
            return 0;
        }
        ProjectConfigurator configurator = this.getProjectConfigurator();
        if (configurator == null) {
            return 0;
        }
        return configurator.check(project, (IProgressMonitor)m);
    }

    public void configure(IProject project, SubMonitor m) {
        this.configurator.configure(project, (IProgressMonitor)m);
    }

    public String toString() {
        return "ConfiguratorTask '" + this.label + "'";
    }
}

