/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.net.resourcemapping.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.statet.ecommons.net.resourcemapping.core.IResourceMappingManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceMappingUtils {
    private static final String BUNDLE_ID = "org.eclipse.statet.ecommons.net.core";
    private static final Object managerLock = new Object();
    private static ServiceTracker<IResourceMappingManager, ?> managerTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IResourceMappingManager getManager() {
        Object object = managerLock;
        synchronized (object) {
            if (managerTracker == null) {
                Bundle bundle = Platform.getBundle((String)BUNDLE_ID);
                if (bundle.getState() != 32) {
                    return null;
                }
                BundleContext context = bundle.getBundleContext();
                context.addBundleListener((BundleListener)new ManagerBundleListener(bundle));
                managerTracker = new ServiceTracker(context, IResourceMappingManager.class.getName(), null);
                managerTracker.open();
            }
            return (IResourceMappingManager)managerTracker.getService();
        }
    }

    private ResourceMappingUtils() {
    }

    private static class ManagerBundleListener
    implements BundleListener {
        private final long bundleId;

        public ManagerBundleListener(Bundle bundle) {
            this.bundleId = bundle.getBundleId();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent event) {
            if (event.getBundle().getBundleId() == this.bundleId && event.getType() == 4) {
                BundleContext context = event.getBundle().getBundleContext();
                if (context != null) {
                    context.removeBundleListener((BundleListener)this);
                }
                Object object = managerLock;
                synchronized (object) {
                    if (managerTracker != null) {
                        managerTracker.close();
                        managerTracker = null;
                    }
                }
            }
        }
    }
}

