/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpaths.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.jcommons.collections.ImCollection;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathElement;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathElementType;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathAttribute;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathElement;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElementAttribute;

public class BuildpathListElement {
    private final BuildpathElementType type;
    private final IProject project;
    private IPath path;
    private final IPath orginalPath;
    private final IResource resource;
    private boolean isMissing;
    private Object parent;
    private final ArrayList<Object> children;
    private IPath linkTarget;
    private final IPath orginalLinkTarget;
    private IBuildpathElement cachedElement;

    public BuildpathListElement(Object parent, IProject project, BuildpathElementType type, IPath path, IResource resource, IPath linkTarget, boolean newElement) {
        this.type = type;
        this.parent = parent;
        this.children = new ArrayList();
        this.project = project;
        this.isMissing = false;
        this.path = path;
        this.orginalPath = newElement ? null : path;
        this.linkTarget = linkTarget;
        this.orginalLinkTarget = linkTarget;
        this.resource = resource;
        this.initBuiltinAttributes();
    }

    public BuildpathListElement(IProject project, Object parent, IBuildpathElement element, boolean newElement) {
        this.type = element.getType();
        this.parent = parent;
        this.children = new ArrayList();
        this.project = project;
        this.isMissing = false;
        IPath path = element.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = null;
        IPath linkTarget = null;
        switch (element.getType().getName()) {
            case "Source": {
                path = path.removeTrailingSeparator();
                resource = root.findMember(path);
                if (resource == null) {
                    if (root.getWorkspace().validatePath(path.toString(), 2).isOK()) {
                        resource = root.getFolder(path);
                    }
                    this.isMissing = true;
                    break;
                }
                if (!resource.isLinked()) break;
                linkTarget = resource.getLocation();
                break;
            }
            case "Project": {
                resource = root.findMember(path);
                this.isMissing = resource == null;
                break;
            }
            default: {
                throw new UnsupportedOperationException(element.getType().getName());
            }
        }
        this.path = path;
        this.orginalPath = newElement ? null : path;
        this.resource = resource;
        this.linkTarget = linkTarget;
        this.orginalLinkTarget = linkTarget;
        this.initBuiltinAttributes();
        this.setAttribute("Filter.inclusions", element.getInclusionPatterns());
        this.setAttribute("Filter.exclusions", element.getExclusionPatterns());
        this.setAttribute("Source.path", element.getSourceAttachmentPath());
        this.setAttribute("Output.path", element.getOutputPath());
        ImList extraAttributes = element.getExtraAttributes();
        for (IBuildpathAttribute attribute : extraAttributes) {
            if (this.setAttribute(attribute.getName(), attribute.getValue()) != null) continue;
            this.addExtraAttribute(attribute.getName(), attribute.getValue());
        }
    }

    public BuildpathElementType getType() {
        return this.type;
    }

    public IResource getResource() {
        return this.resource;
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getPath() {
        return this.path;
    }

    public IPath getOrginalPath() {
        return this.orginalPath;
    }

    public void setPath(IPath path) {
        this.cachedElement = null;
        this.path = path;
    }

    public IPath getLinkTarget() {
        return this.linkTarget;
    }

    public IPath getOrginalLinkTarget() {
        return this.orginalLinkTarget;
    }

    public void setLinkTarget(IPath linkTarget) {
        this.cachedElement = null;
        this.linkTarget = linkTarget;
    }

    public IBuildpathElement getCoreElement() {
        if (this.cachedElement == null) {
            this.cachedElement = this.newCoreElement();
        }
        return this.cachedElement;
    }

    private IBuildpathElement newCoreElement() {
        return new BuildpathElement(this.type, this.path, this.type.isAttributeBuiltin("Filter.inclusions") ? (ImList)this.getAttributeValue("Filter.inclusions") : null, this.type.isAttributeBuiltin("Filter.exclusions") ? (ImList)this.getAttributeValue("Filter.exclusions") : null, this.type.isAttributeBuiltin("Source.path") ? (IPath)this.getAttributeValue("Source.path") : null, null, this.type.isAttributeBuiltin("Output.path") ? (IPath)this.getAttributeValue("Output.path") : null, null, false, ImCollections.toList(this.getExtraAttributes()));
    }

    public List<Object> getChildren() {
        return this.getFilteredChildren((ImCollection<String>)ImCollections.emptySet());
    }

    private void initBuiltinAttributes() {
        Iterator iterator = this.type.getAttributeBuiltinKeys().iterator();
        while (iterator.hasNext()) {
            String attributeKey;
            switch (attributeKey = (String)iterator.next()) {
                case "Filter.exclusions": 
                case "Filter.inclusions": {
                    this.createAttribute(attributeKey, ImCollections.emptyList(), true);
                    break;
                }
                case "Output.path": {
                    this.createAttribute(attributeKey, null, true);
                    break;
                }
                default: {
                    throw new IllegalStateException(attributeKey);
                }
            }
        }
    }

    private List<IBuildpathAttribute> getExtraAttributes() {
        ArrayList<IBuildpathAttribute> list = new ArrayList<IBuildpathAttribute>(Math.min(this.children.size(), 8));
        for (Object child : this.children) {
            BuildpathListElementAttribute attribute;
            if (!(child instanceof BuildpathListElementAttribute) || (attribute = (BuildpathListElementAttribute)child).isBuiltin() || attribute.getValue() == null) continue;
            list.add(attribute.getCoreAttribute());
        }
        return list;
    }

    private boolean isFiltered(Object child, ImCollection<String> filteredAttributeKeys) {
        if (child instanceof BuildpathListElementAttribute) {
            BuildpathListElementAttribute attribute = (BuildpathListElementAttribute)child;
            if (filteredAttributeKeys.contains((Object)attribute.getName())) {
                return true;
            }
            if (attribute.getStatus().getCode() == 65536) {
                return true;
            }
            attribute.isBuiltin();
        }
        return false;
    }

    public List<Object> getFilteredChildren(ImCollection<String> filteredAttributeKeys) {
        int nChildren = this.children.size();
        ArrayList<Object> filtered = new ArrayList<Object>(nChildren);
        int i = 0;
        while (i < nChildren) {
            Object child = this.children.get(i);
            if (!this.isFiltered(child, filteredAttributeKeys)) {
                filtered.add(child);
            }
            ++i;
        }
        return filtered;
    }

    public BuildpathListElementAttribute findAttribute(String name) {
        for (Object child : this.children) {
            BuildpathListElementAttribute attribute;
            if (!(child instanceof BuildpathListElementAttribute) || !name.equals((attribute = (BuildpathListElementAttribute)child).getName())) continue;
            return attribute;
        }
        return null;
    }

    public Object getAttributeValue(String name) {
        BuildpathListElementAttribute attribute = this.findAttribute(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    public List<BuildpathListElementAttribute> getAllAttributes() {
        ArrayList<BuildpathListElementAttribute> attributes = new ArrayList<BuildpathListElementAttribute>();
        for (Object child : this.children) {
            if (!(child instanceof BuildpathListElementAttribute)) continue;
            attributes.add((BuildpathListElementAttribute)child);
        }
        return attributes;
    }

    protected void attributeChanged(String name) {
        this.cachedElement = null;
    }

    public BuildpathListElementAttribute setAttribute(String name, Object value) {
        BuildpathListElementAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            return null;
        }
        switch (name) {
            case "Filter.exclusions": 
            case "Filter.inclusions": {
                if (value instanceof ImList) break;
                throw new IllegalArgumentException();
            }
        }
        attribute.setValue(value);
        return attribute;
    }

    private BuildpathListElementAttribute createAttribute(String name, Object value, boolean builtin) {
        BuildpathListElementAttribute attribute = new BuildpathListElementAttribute(this, name, value, builtin);
        this.children.add(attribute);
        return attribute;
    }

    public void setAttributesFromExisting(BuildpathListElement existing) {
        Assert.isTrue((existing.getType() == this.getType() ? 1 : 0) != 0);
        List<BuildpathListElementAttribute> attributes = existing.getAllAttributes();
        for (BuildpathListElementAttribute attribute : attributes) {
            BuildpathListElementAttribute elem = this.findAttribute(attribute.getName());
            if (elem == null) {
                this.createAttribute(attribute.getName(), attribute.getValue(), false);
                continue;
            }
            elem.setValue(attribute.getValue());
        }
    }

    public BuildpathListElementAttribute addExtraAttribute(String name, Object value) {
        return this.createAttribute(name, value, false);
    }

    public Object getParent() {
        return this.parent;
    }

    void setParentContainer(Object parent) {
        this.parent = parent;
    }

    private IStatus evaluateContainerChildStatus(BuildpathListElementAttribute attrib) {
        return null;
    }

    public IStatus getContainerChildStatus(BuildpathListElementAttribute attrib) {
        if (this.parent instanceof BuildpathListElement) {
            BuildpathListElement parentElement = (BuildpathListElement)this.parent;
            return parentElement.getContainerChildStatus(attrib);
        }
        return Status.OK_STATUS;
    }

    public boolean isInContainer(String containerName) {
        if (this.parent instanceof BuildpathListElement) {
            BuildpathListElement elem = (BuildpathListElement)this.parent;
            return new Path(containerName).isPrefixOf(elem.getPath());
        }
        return false;
    }

    public boolean isMissing() {
        return this.isMissing;
    }

    public boolean hasMissingChildren() {
        for (Object child : this.children) {
            if (!(child instanceof BuildpathListElement) || !((BuildpathListElement)child).isMissing()) continue;
            return true;
        }
        return false;
    }

    public void setIsMissing(boolean isMissing) {
        this.isMissing = isMissing;
    }

    public boolean isDeprecated() {
        return false;
    }

    public String getDeprecationMessage() {
        return null;
    }

    public int hashCode() {
        return this.type.hashCode() + this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj.getClass().equals(this.getClass())) {
            BuildpathListElement other = (BuildpathListElement)obj;
            return this.getCoreElement().equals(other.getCoreElement());
        }
        return false;
    }

    public String toString() {
        return this.getCoreElement().toString();
    }
}

