/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.tools;

import java.net.URI;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.tools.LoadRImageRunnable;
import org.eclipse.statet.internal.r.ui.tools.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolInfoGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LoadRImageWizard
extends Wizard {
    private static final ImList<String[]> RIMAGE_FILE_FILTERS = ImCollections.newList((Object)new String[]{"*.RData", Messages.LoadData_Wizard_File_RImages_name});
    ToolProcess fTool;
    SelectFileDialog fPage;

    public LoadRImageWizard(ToolProcess tool) {
        this.fTool = tool;
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"r/tools/loadData-Wizard"));
        this.setWindowTitle(Messages.LoadData_Wizard_title);
        this.setNeedsProgressMonitor(false);
    }

    public void addPages() {
        this.fPage = new SelectFileDialog();
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        this.fPage.saveSettings();
        LoadRImageRunnable runnable = new LoadRImageRunnable(this.fPage.getResource());
        this.fTool.getQueue().add((ToolRunnable)runnable);
        return true;
    }

    private class SelectFileDialog
    extends WizardPage {
        private static final String SETTINGS_HISTORY = "statet:location.rdata";
        private ResourceInputComposite fLocationGroup;
        private final WritableValue fNewLocationString;
        private DataBindingContext fDbc;

        public SelectFileDialog() {
            super("LoadData.SelectFile");
            this.setTitle(Messages.LoadData_Wizard_SelectPage_title);
            this.setDescription(Messages.LoadData_Wizard_SelectPage_description);
            Realm realm = Realm.getDefault();
            this.fNewLocationString = new WritableValue(realm, (Object)"", String.class);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            container.setLayout((Layout)new GridLayout());
            this.setControl((Control)container);
            this.createContents(container);
            LayoutUtils.addSmallFiller((Composite)container, (boolean)true);
            ToolInfoGroup info = new ToolInfoGroup(container, LoadRImageWizard.this.fTool);
            info.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
            Dialog.applyDialogFont((Control)container);
            this.setErrorMessage(null);
            this.setMessage(null);
        }

        protected void createContents(Composite container) {
            IPath path;
            this.fLocationGroup = new ResourceInputComposite(container, 1, 9, Messages.LoadData_Wizard_File_label);
            this.fLocationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            this.fLocationGroup.setHistory(this.getDialogSettings().getArray(SETTINGS_HISTORY));
            String dir = "";
            IFileStore current = LoadRImageWizard.this.fTool.getWorkspaceData().getWorkspaceDir();
            if (current != null && (path = URIUtil.toPath((URI)current.toURI())) != null) {
                dir = path.toOSString();
            }
            this.fLocationGroup.setDefaultFilesystemPath(dir);
            this.fLocationGroup.setFileFilters((List)RIMAGE_FILE_FILTERS);
            Realm realm = Realm.getDefault();
            this.fDbc = new DataBindingContext(realm);
            this.fDbc.bindValue(this.fLocationGroup.getObservable(), (IObservableValue)this.fNewLocationString, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.fLocationGroup.getValidator()), null);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.fDbc);
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)SETTINGS_HISTORY, (String)((String)this.fNewLocationString.getValue()));
        }

        public IFileStore getResource() {
            return this.fLocationGroup.getResourceAsFileStore();
        }

        public void dispose() {
            if (this.fDbc != null) {
                this.fDbc.dispose();
                this.fDbc = null;
            }
            super.dispose();
        }
    }
}

