/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.BracketLevel;
import org.eclipse.statet.jcommons.collections.ImCollections;

public final class RBracketLevel
extends BracketLevel {
    public static final BracketLevel.InBracketPosition createPosition(char c, IDocument document, int offset, int length, int sequence) {
        switch (c) {
            case '\"': {
                return new StringDPosition(document, offset, length, sequence);
            }
            case '\'': {
                return new StringSPosition(document, offset, length, sequence);
            }
            case '`': {
                return new QuotedPosition(document, offset, length, sequence);
            }
            case '{': {
                return new CurlyBracketPosition(document, offset, length, sequence);
            }
            case '(': {
                return new RoundBracketPosition(document, offset, length, sequence);
            }
            case '[': {
                return new SquareBracketPosition(document, offset, length, sequence);
            }
            case '%': {
                return new InfixLevel(document, offset, length, sequence);
            }
        }
        throw new IllegalArgumentException();
    }

    public RBracketLevel(LinkedModeModel model, IDocument document, DocContentSections documentContentInfo, BracketLevel.InBracketPosition position, boolean consoleMode, boolean autoDelete) {
        this(model, document, documentContentInfo, (List<LinkedPosition>)ImCollections.newList((Object)position), (consoleMode ? 1 : 0) | (autoDelete ? 0x1000000 : 0));
    }

    public RBracketLevel(LinkedModeModel model, IDocument document, DocContentSections documentContentInfo, List<LinkedPosition> positions, int mode) {
        super(model, document, documentContentInfo, positions, mode);
    }

    public static final class CurlyBracketPosition
    extends BracketLevel.InBracketPosition {
        public CurlyBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '{';
        }

        public char getCloseChar() {
            return '}';
        }
    }

    public static final class InfixLevel
    extends BracketLevel.InBracketPosition {
        public InfixLevel(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '%';
        }

        public char getCloseChar() {
            return '%';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        public boolean matchesClose(BracketLevel level, int offset, char character) {
            return this.getOffset() + this.getLength() == offset && this.getCloseChar() == character;
        }
    }

    public static final class QuotedPosition
    extends BracketLevel.InBracketPosition {
        public QuotedPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '`';
        }

        public char getCloseChar() {
            return '`';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }

    public static final class RoundBracketPosition
    extends BracketLevel.InBracketPosition {
        public RoundBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '(';
        }

        public char getCloseChar() {
            return ')';
        }
    }

    public static final class SquareBracketPosition
    extends BracketLevel.InBracketPosition {
        public SquareBracketPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '[';
        }

        public char getCloseChar() {
            return ']';
        }
    }

    public static final class StringDPosition
    extends BracketLevel.InBracketPosition {
        public StringDPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\"';
        }

        public char getCloseChar() {
            return '\"';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }

    public static final class StringSPosition
    extends BracketLevel.InBracketPosition {
        public StringSPosition(IDocument doc, int offset, int length, int sequence) {
            super(doc, offset, length, sequence);
        }

        public char getOpenChar() {
            return '\'';
        }

        public char getCloseChar() {
            return '\'';
        }

        public boolean insertCR(int charOffset) {
            return false;
        }

        protected boolean isEscaped(int offset) throws BadLocationException {
            return TextUtil.countBackward((IDocument)this.getDocument(), (int)offset, (char)'\\') % 2 == 1;
        }
    }
}

