/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.base.ext.ui.text.CommentScanner;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.ColorManager;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.REditor;
import org.eclipse.statet.internal.r.ui.editors.REditorInformationProvider;
import org.eclipse.statet.internal.r.ui.editors.REditorTextHover;
import org.eclipse.statet.internal.r.ui.editors.RQuickOutlineInformationProvider;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.EditorInformationProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.QuickAssistProcessor;
import org.eclipse.statet.nico.ui.console.ConsolePageEditor;
import org.eclipse.statet.r.core.IRCoreAccess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.source.IRDocumentConstants;
import org.eclipse.statet.r.core.source.RDocumentContentInfo;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.sourceediting.RAutoEditStrategy;
import org.eclipse.statet.r.ui.sourceediting.RContentAssistProcessor;
import org.eclipse.statet.r.ui.sourceediting.RQuickAssistProcessor;
import org.eclipse.statet.r.ui.text.r.RBracketPairMatcher;
import org.eclipse.statet.r.ui.text.r.RDefaultTextStyleScanner;
import org.eclipse.statet.r.ui.text.r.RDoubleClickStrategy;
import org.eclipse.statet.r.ui.text.r.RInfixOperatorScanner;
import org.eclipse.statet.r.ui.text.r.RoxygenScanner;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.spelling.SpellingReconcileStrategy;
import org.eclipse.ui.texteditor.spelling.SpellingService;

public class RSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])IRDocumentConstants.R_CONTENT_TYPES.toArray((Object[])new String[IRDocumentConstants.R_CONTENT_TYPES.size()]);
    private RDoubleClickStrategy fDoubleClickStrategy;
    private RAutoEditStrategy fAutoEditStrategy;
    private IRCoreAccess fRCoreAccess;

    public RSourceViewerConfiguration(int flags, IPreferenceStore store, ColorManager colorManager) {
        this((DocContentSections)RDocumentContentInfo.INSTANCE, flags, null, null, store, null);
    }

    public RSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, IRSourceEditor sourceEditor, IRCoreAccess access, IPreferenceStore preferenceStore, TextStyleManager textStyles) {
        super(documentContentInfo, flags, (ISourceEditor)sourceEditor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : RUIPlugin.getInstance().getEditorPreferenceStore(), LTKUIPreferences.getEditorDecorationPreferences(), LTKUIPreferences.getAssistPreferences());
        this.setTextStyles(textStyles);
    }

    protected void setCoreAccess(IRCoreAccess access) {
        this.fRCoreAccess = access != null ? access : RCore.getWorkbenchAccess();
    }

    protected IRSourceEditor getSourceEditor() {
        return (IRSourceEditor)super.getSourceEditor();
    }

    protected void initTextStyles() {
        this.setTextStyles(RUIPlugin.getInstance().getRTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("R.Default", new RDefaultTextStyleScanner(textStyles));
        this.addScanner("R.Op.Infix", (ITokenScanner)new RInfixOperatorScanner(textStyles));
        this.addScanner("R.String", (ITokenScanner)new SingleTokenScanner(textStyles, "text_R_rString"));
        this.addScanner("R.Comment", (ITokenScanner)new CommentScanner(textStyles, "text_R_rComment", "text_R_taskTag", this.fRCoreAccess.getPrefs()));
        this.addScanner("R.Roxygen", (ITokenScanner)new RoxygenScanner(textStyles, this.fRCoreAccess.getPrefs()));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType == "R.QuotedSymbol") {
            contentType = "R.String";
        }
        return super.getScanner(contentType);
    }

    public IRCoreAccess getRCoreAccess() {
        return this.fRCoreAccess;
    }

    public List<ISourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.fAutoEditStrategy != null) {
            addons.add(this.fAutoEditStrategy);
        }
        return addons;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        options.put("context.PrefAccess", this.fRCoreAccess.getPrefs());
        super.handleSettingsChanged(groupIds, options);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public ICharPairMatcher createPairMatcher() {
        return new RBracketPairMatcher(RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.fDoubleClickStrategy == null) {
            this.fDoubleClickStrategy = new RDoubleClickStrategy(RHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
        }
        return this.fDoubleClickStrategy;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    protected IIndentSettings getIndentSettings() {
        return this.fRCoreAccess.getRCodeStyle();
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue((Preference)REditorOptions.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.fAutoEditStrategy == null) {
            this.fAutoEditStrategy = this.createRAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.fAutoEditStrategy};
    }

    protected RAutoEditStrategy createRAutoEditStrategy() {
        return new RAutoEditStrategy(this.fRCoreAccess, this.getSourceEditor());
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        IReconcilingStrategy spellingStrategy;
        IRSourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1) && !(editor instanceof ConsolePageEditor)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2((ISourceEditor)editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        if (editor instanceof REditor && (spellingStrategy = this.getSpellingStrategy(sourceViewer)) != null) {
            reconciler.addReconcilingStrategy(spellingStrategy);
        }
        return reconciler;
    }

    protected IReconcilingStrategy getSpellingStrategy(ISourceViewer sourceViewer) {
        if (!((Boolean)this.fRCoreAccess.getPrefs().getPreferenceValue((Preference)REditorOptions.PREF_SPELLCHECKING_ENABLED)).booleanValue() || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        return new SpellingReconcileStrategy(sourceViewer, spellingService);
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = RUIPlugin.getInstance().getREditorContentAssistRegistry();
        IRSourceEditor editor = this.getSourceEditor();
        RContentAssistProcessor codeProcessor = new RContentAssistProcessor(assistant, "R.Default", registry, editor);
        codeProcessor.setCompletionProposalAutoActivationCharacters(new char[]{'$', '@'});
        codeProcessor.setContextInformationAutoActivationCharacters(new char[]{','});
        assistant.setContentAssistProcessor((IContentAssistProcessor)codeProcessor, "R.Default");
        RContentAssistProcessor symbolProcessor = new RContentAssistProcessor(assistant, "R.QuotedSymbol", registry, editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)symbolProcessor, "R.QuotedSymbol");
        RContentAssistProcessor stringProcessor = new RContentAssistProcessor(assistant, "R.String", registry, editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)stringProcessor, "R.String");
        RContentAssistProcessor commentProcessor = new RContentAssistProcessor(assistant, "R.Comment", registry, editor);
        assistant.setContentAssistProcessor((IContentAssistProcessor)commentProcessor, "R.Comment");
        RContentAssistProcessor roxygenProcessor = new RContentAssistProcessor(assistant, "R.Roxygen", registry, editor);
        roxygenProcessor.setCompletionProposalAutoActivationCharacters(new char[]{'@', '\\'});
        assistant.setContentAssistProcessor((IContentAssistProcessor)roxygenProcessor, "R.Roxygen");
    }

    protected QuickAssistProcessor createQuickAssistProcessor() {
        IRSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new RQuickAssistProcessor(editor);
        }
        return null;
    }

    protected boolean isInfoHoverDefaultContentType(String contentType) {
        return IRDocumentConstants.R_CODE_CONTENT_CONSTRAINT.matches(contentType);
    }

    protected InfoHoverRegistry getInfoHoverRegistry() {
        return RUIPlugin.getInstance().getREditorInfoHoverRegistry();
    }

    protected ITextHover createInfoHover(InfoHoverDescriptor descriptor) {
        IRSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new REditorTextHover(editor, descriptor, this);
        }
        return null;
    }

    protected EditorInformationProvider getInformationProvider() {
        IRSourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new REditorInformationProvider(editor);
        }
        return null;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.r.editorHyperlinks.REditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        IRSourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new RQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }
}

