/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Widget;

public class ColorSelectorObservableValue
extends AbstractSWTObservableValue<RGB> {
    private final ColorSelector selector;
    private RGB value;
    private final IPropertyChangeListener updateListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            RGB oldValue = (RGB)event.getOldValue();
            RGB newValue = (RGB)event.getNewValue();
            ColorSelectorObservableValue.this.value = newValue;
            ColorSelectorObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)newValue));
        }
    };

    public ColorSelectorObservableValue(ColorSelector selector) {
        super((Widget)selector.getButton());
        this.selector = selector;
        this.selector.addListener(this.updateListener);
    }

    public synchronized void dispose() {
        this.selector.removeListener(this.updateListener);
        super.dispose();
    }

    public Object getValueType() {
        return RGB.class;
    }

    public void doSetValue(RGB value) {
        RGB oldValue = this.value;
        this.value = value;
        this.selector.setColorValue(this.value != null ? this.value : new RGB(0, 0, 0));
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.value));
    }

    public RGB doGetValue() {
        return this.selector.getColorValue();
    }
}

