/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class UriUtils {
    public static final String HTTP_SCHEME = "http";
    public static final String HTTPS_SCHEME = "https";
    public static final String FILE_SCHEME = "file";
    public static final String JAR_SCHEME = "jar";
    public static final String JAR_SEPARATOR = "!/";

    public static final URI toUri(URL url) throws URISyntaxException {
        String s = url.toExternalForm();
        String scheme = url.getProtocol();
        String fragment = url.getRef();
        String spp = s.substring(scheme.length() + 1, fragment != null ? s.length() - fragment.length() - 1 : s.length());
        return new URI(scheme, spp, fragment);
    }

    public static final boolean isFileUrl(URI url) {
        String scheme = url.getScheme();
        return scheme != null && scheme.equalsIgnoreCase(FILE_SCHEME);
    }

    public static final boolean isJarUrl(URI url) {
        String scheme = url.getScheme();
        return scheme != null && scheme.equalsIgnoreCase(JAR_SCHEME);
    }

    public static final URI getJarFileUrl(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.lastIndexOf(JAR_SEPARATOR, jarSepIdx - 1) == -1 ? new URI(ssp.substring(0, containerSchemeIdx), ssp.substring(containerSchemeIdx + 1, jarSepIdx), url.getFragment()) : new URI(url.getScheme(), ssp.substring(0, jarSepIdx), url.getFragment());
    }

    public static final String getJarEntryPath(URI url) throws URISyntaxException {
        String ssp = url.getSchemeSpecificPart();
        int containerSchemeIdx = ssp.indexOf(58);
        if (containerSchemeIdx <= 0) {
            throw new URISyntaxException(url.toString(), "missing container scheme");
        }
        int jarSepIdx = ssp.lastIndexOf(JAR_SEPARATOR);
        if (jarSepIdx < containerSchemeIdx) {
            throw new URISyntaxException(url.toString(), "missing JAR separator");
        }
        return ssp.substring(jarSepIdx + 2, ssp.length());
    }

    public static final String toJarUrlString(String jarFileUrlString) throws URISyntaxException {
        StringBuilder sb = new StringBuilder(jarFileUrlString.length() + 6);
        if (!jarFileUrlString.startsWith("jar:")) {
            sb.append("jar:");
        }
        sb.append(jarFileUrlString);
        sb.append(JAR_SEPARATOR);
        return sb.toString();
    }

    private UriUtils() {
    }
}

